/*
 * Decompiled with CFR 0.152.
 */
package com.github.vbauer.vfs2.provider.smb;

import com.github.vbauer.vfs2.provider.smb.SmbFileName;
import com.github.vbauer.vfs2.provider.smb.SmbFileProvider;
import com.github.vbauer.vfs2.provider.smb.SmbFileRandomAccessContent;
import com.github.vbauer.vfs2.provider.smb.SmbFileSystem;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public class SmbFileObject
extends AbstractFileObject
implements FileObject {
    private SmbFile file;

    protected SmbFileObject(AbstractFileName name, SmbFileSystem fileSystem) {
        super(name, (AbstractFileSystem)fileSystem);
    }

    protected void doAttach() throws Exception {
        if (this.file == null) {
            this.file = this.createSmbFile(this.getName());
        }
    }

    protected void doDetach() throws Exception {
        this.file = null;
    }

    protected FileType doGetType() throws Exception {
        if (!this.file.exists()) {
            return FileType.IMAGINARY;
        }
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        if (this.file.isFile()) {
            return FileType.FILE;
        }
        throw new FileSystemException("vfs.provider.smb/get-type.error", (Object)this.getName());
    }

    protected String[] doListChildren() throws Exception {
        return UriParser.encode((String[])this.file.list());
    }

    protected boolean doIsHidden() throws Exception {
        return this.file.isHidden();
    }

    protected void doDelete() throws Exception {
        this.file.delete();
    }

    protected void doRename(FileObject newFile) throws Exception {
        this.file.renameTo(this.createSmbFile(newFile.getName()));
    }

    protected void doCreateFolder() throws Exception {
        this.file.mkdir();
        this.file = this.createSmbFile(this.getName());
    }

    protected long doGetContentSize() throws Exception {
        return this.file.length();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.file.getLastModified();
    }

    protected InputStream doGetInputStream() throws Exception {
        return new SmbFileInputStream(this.file);
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new SmbFileOutputStream(this.file, bAppend);
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new SmbFileRandomAccessContent(this.file, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SmbFile createSmbFile(FileName fileName) throws MalformedURLException, SmbException, FileSystemException {
        SmbFile file;
        NtlmPasswordAuthentication auth;
        SmbFileName smbFileName = (SmbFileName)fileName;
        String path = smbFileName.getUriWithoutAuth();
        UserAuthenticationData authData = null;
        try {
            FileSystemOptions fileSystemOptions = this.getFileSystem().getFileSystemOptions();
            authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)fileSystemOptions, (UserAuthenticationData.Type[])SmbFileProvider.AUTHENTICATOR_TYPES);
            auth = this.createNtlmPasswordAuthentication(smbFileName, authData);
            file = new SmbFile(path, auth);
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
        if (file.isDirectory() && !file.toString().endsWith("/")) {
            file = new SmbFile(path + "/", auth);
        }
        return file;
    }

    private NtlmPasswordAuthentication createNtlmPasswordAuthentication(SmbFileName smbFileName, UserAuthenticationData authData) {
        String domain = this.getAuthValue(authData, UserAuthenticationData.DOMAIN, smbFileName.getDomain());
        String username = this.getAuthValue(authData, UserAuthenticationData.USERNAME, smbFileName.getUserName());
        String password = this.getAuthValue(authData, UserAuthenticationData.PASSWORD, smbFileName.getPassword());
        return new NtlmPasswordAuthentication(domain, username, password);
    }

    private String getAuthValue(UserAuthenticationData authData, UserAuthenticationData.Type type, String value) {
        return UserAuthenticatorUtils.toString((char[])UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)type, (char[])UserAuthenticatorUtils.toChar((String)value)));
    }
}

