/*
 * Decompiled with CFR 0.152.
 */
package com.github.vbauer.vfs2.provider.smb;

import java.io.IOException;
import java.io.InputStream;
import jcifs.smb.SmbRandomAccessFile;

public class SmbFileInputStream
extends InputStream {
    private final SmbRandomAccessFile raf;

    public SmbFileInputStream(SmbRandomAccessFile raf) {
        this.raf = raf;
    }

    @Override
    public int read() throws IOException {
        return this.raf.readByte();
    }

    @Override
    public long skip(long n) throws IOException {
        this.raf.seek(this.raf.getFilePointer() + n);
        return n;
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.raf.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.raf.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        long available = this.raf.length() - this.raf.getFilePointer();
        return (int)Math.min(available, Integer.MAX_VALUE);
    }
}

