/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class PdfUtil {
    public static final String NEW_LINE_REGEX = "\\r?\\n";
    public static final double EPSILON = 1.0E-4;
    private static final Map<String, String> SPLIT_BY_AND_REPLACEMENT_MAP = new LinkedHashMap<String, String>();

    private PdfUtil() {
    }

    public static float getStringWidth(String text, PDFont font, int fontSize) {
        return Arrays.stream(text.split(NEW_LINE_REGEX)).max(Comparator.comparing(String::length)).map(x -> Float.valueOf(PdfUtil.getWidthOfStringWithoutNewlines(x, font, fontSize))).orElseThrow(CouldNotDetermineStringWidthException::new).floatValue();
    }

    private static float getWidthOfStringWithoutNewlines(String text, PDFont font, int fontSize) {
        StringBuilder printable = new StringBuilder();
        int unprintable = 0;
        List codePointsAsString = text.codePoints().mapToObj(codePoint -> new String(new int[]{codePoint}, 0, 1)).collect(Collectors.toList());
        for (String codepoint : codePointsAsString) {
            try {
                font.encode(codepoint);
                printable.append(codepoint);
            }
            catch (IllegalArgumentException e) {
                ++unprintable;
            }
        }
        float unprintableLength = font.getStringWidth("\u2013") * (float)unprintable * (float)fontSize / 1000.0f;
        float printableLength = font.getStringWidth(printable.toString()) * (float)fontSize / 1000.0f;
        return printableLength + unprintableLength;
    }

    public static float getFontHeight(PDFont font, int fontSize) {
        return font.getFontDescriptor().getCapHeight() * (float)fontSize / 1000.0f;
    }

    public static List<String> getOptimalTextBreakLines(String text, PDFont font, int fontSize, float maxWidth) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : text.split(NEW_LINE_REGEX)) {
            if (PdfUtil.doesTextLineFit(line, font, fontSize, maxWidth)) {
                result.add(line);
                continue;
            }
            result.addAll(PdfUtil.wrapLine(line, font, fontSize, maxWidth));
        }
        return result;
    }

    private static List<String> wrapLine(String line, PDFont font, int fontSize, float maxWidth) {
        if (PdfUtil.doesTextLineFit(line, font, fontSize, maxWidth)) {
            return Collections.singletonList(line);
        }
        List<Object> result = new ArrayList<String>();
        result.add(line);
        for (Map.Entry<String, String> entry : SPLIT_BY_AND_REPLACEMENT_MAP.entrySet()) {
            String splitRegex = entry.getKey();
            String replacement = entry.getValue();
            if (!(result = result.stream().flatMap(subLine -> {
                List<String> newLines = PdfUtil.splitBy(splitRegex, subLine, font, fontSize, maxWidth, replacement);
                if (newLines.isEmpty()) {
                    newLines.add(line);
                }
                return newLines.stream();
            }).collect(Collectors.toList())).stream().allMatch(subLine -> PdfUtil.doesTextLineFit(subLine, font, fontSize, maxWidth))) continue;
            break;
        }
        return result.stream().flatMap(subLine -> {
            if (PdfUtil.doesTextLineFit(subLine, font, fontSize, maxWidth)) {
                return Stream.of(subLine);
            }
            return PdfUtil.splitBySize(subLine, font, fontSize, maxWidth).stream();
        }).collect(Collectors.toList());
    }

    private static List<String> splitBySize(String line, PDFont font, int fontSize, float maxWidth) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (int i = line.length() - 1; i > 0; --i) {
            String fittedNewLine = line.substring(0, i) + "-";
            String remains = line.substring(i);
            if (!PdfUtil.doesTextLineFit(fittedNewLine, font, fontSize, maxWidth)) continue;
            returnList.add(fittedNewLine);
            returnList.addAll(PdfUtil.wrapLine(remains, font, fontSize, maxWidth));
            break;
        }
        return returnList;
    }

    private static List<String> splitBy(String by, String line, PDFont font, int fontSize, float maxWidth, String replacementString) {
        ArrayList<String> returnList = new ArrayList<String>();
        List<String> splitBy = Arrays.asList(line.split(by));
        for (int i = splitBy.size() - 1; i >= 0; --i) {
            String fittedNewLine = String.join((CharSequence)replacementString, splitBy.subList(0, i));
            String remains = String.join((CharSequence)replacementString, splitBy.subList(i, splitBy.size()));
            if (fittedNewLine.isEmpty() || !PdfUtil.doesTextLineFit(fittedNewLine, font, fontSize, maxWidth)) continue;
            returnList.add(String.format("%s%s", fittedNewLine, replacementString).trim());
            if (Objects.equals(remains, line)) break;
            returnList.addAll(PdfUtil.wrapLine(String.format("%s%s", remains, replacementString).trim(), font, fontSize, maxWidth));
            break;
        }
        return returnList;
    }

    private static boolean doesTextLineFit(String textLine, PDFont font, int fontSize, float maxWidth) {
        float stringWidth = PdfUtil.getStringWidth(textLine, font, fontSize);
        float difference = Math.abs(maxWidth - stringWidth);
        if ((double)difference < 1.0E-4) {
            return true;
        }
        return maxWidth > stringWidth;
    }

    static {
        SPLIT_BY_AND_REPLACEMENT_MAP.put(" ", " ");
        SPLIT_BY_AND_REPLACEMENT_MAP.put("\\.", ".");
        SPLIT_BY_AND_REPLACEMENT_MAP.put(",", ",");
    }

    private static class CouldNotDetermineStringWidthException
    extends RuntimeException {
        CouldNotDetermineStringWidthException() {
        }
    }
}

