/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.drawing.cell;

import java.awt.Color;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.drawing.DrawingUtil;
import org.vandeseer.easytable.drawing.PositionedStyledText;
import org.vandeseer.easytable.drawing.cell.AbstractCellDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.structure.cell.AbstractTextCell;
import org.vandeseer.easytable.util.PdfUtil;

public class TextCellDrawer<T extends AbstractTextCell>
extends AbstractCellDrawer<AbstractTextCell> {
    public TextCellDrawer(T cell) {
        this.cell = cell;
    }

    @Override
    public void drawContent(DrawingContext drawingContext) {
        float startX = drawingContext.getStartingPoint().x;
        PDFont currentFont = ((AbstractTextCell)this.cell).getFont();
        int currentFontSize = ((AbstractTextCell)this.cell).getFontSize();
        Color currentTextColor = ((AbstractTextCell)this.cell).getTextColor();
        float yOffset = drawingContext.getStartingPoint().y + this.getAdaptionForVerticalAlignment();
        float xOffset = startX + ((AbstractTextCell)this.cell).getPaddingLeft();
        List<String> lines = this.calculateAndGetLines(currentFont, currentFontSize, ((AbstractTextCell)this.cell).getWidthOfText());
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            yOffset -= this.calculateYOffset(currentFont, currentFontSize, i);
            float textWidth = PdfUtil.getStringWidth(line, currentFont, currentFontSize);
            if (((AbstractTextCell)this.cell).isHorizontallyAligned(HorizontalAlignment.RIGHT)) {
                xOffset = startX + (((AbstractTextCell)this.cell).getWidth() - (textWidth + ((AbstractTextCell)this.cell).getPaddingRight()));
            } else if (((AbstractTextCell)this.cell).isHorizontallyAligned(HorizontalAlignment.CENTER)) {
                xOffset = startX + (((AbstractTextCell)this.cell).getWidth() - textWidth) / 2.0f;
            } else if (((AbstractTextCell)this.cell).isHorizontallyAligned(HorizontalAlignment.JUSTIFY) && TextCellDrawer.isNotLastLine(lines, i)) {
                drawingContext.getContentStream().setCharacterSpacing(this.calculateCharSpacingFor(line));
            }
            this.drawText(drawingContext, PositionedStyledText.builder().x(xOffset).y(yOffset).text(line).font(currentFont).fontSize(currentFontSize).color(currentTextColor).build());
        }
    }

    @Override
    protected float calculateInnerHeight() {
        return ((AbstractTextCell)this.cell).getTextHeight();
    }

    private float calculateYOffset(PDFont currentFont, int currentFontSize, int lineIndex) {
        return PdfUtil.getFontHeight(currentFont, currentFontSize) + (lineIndex > 0 ? PdfUtil.getFontHeight(currentFont, currentFontSize) * ((AbstractTextCell)this.cell).getLineSpacing() : 0.0f);
    }

    static boolean isNotLastLine(List<String> lines, int i) {
        return i != lines.size() - 1;
    }

    protected float calculateCharSpacingFor(String line) {
        float charSpacing = 0.0f;
        if (line.length() > 1) {
            float size = PdfUtil.getStringWidth(line, ((AbstractTextCell)this.cell).getFont(), ((AbstractTextCell)this.cell).getFontSize());
            float free = ((AbstractTextCell)this.cell).getWidthOfText() - size;
            if (free > 0.0f) {
                charSpacing = free / (float)(line.length() - 1);
            }
        }
        return charSpacing;
    }

    protected List<String> calculateAndGetLines(PDFont currentFont, int currentFontSize, float maxWidth) {
        return ((AbstractTextCell)this.cell).isWordBreak() ? PdfUtil.getOptimalTextBreakLines(((AbstractTextCell)this.cell).getText(), currentFont, currentFontSize, maxWidth) : Collections.singletonList(((AbstractTextCell)this.cell).getText());
    }

    protected void drawText(DrawingContext drawingContext, PositionedStyledText positionedStyledText) throws IOException {
        DrawingUtil.drawText(drawingContext.getContentStream(), positionedStyledText);
    }

    public TextCellDrawer() {
    }
}

