/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.drawing.cell;

import java.awt.Color;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.drawing.DrawingUtil;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import org.vandeseer.easytable.util.PdfUtil;

public class TextCellDrawer
implements Drawer {
    private TextCell cell;

    public TextCellDrawer() {
    }

    public TextCellDrawer(TextCell cell) {
        this.cell = cell;
    }

    @Override
    public void setCell(AbstractCell cell) {
        this.cell = (TextCell)cell;
    }

    @Override
    public void draw(DrawingContext drawingContext) throws IOException {
        float startX = drawingContext.getStartingPoint().x;
        float startY = drawingContext.getStartingPoint().y;
        PDFont currentFont = this.cell.getFont();
        int currentFontSize = this.cell.getFontSize();
        Color currentTextColor = this.cell.getTextColor();
        float maxWidth = this.cell.getWidthOfText();
        float yStartRelative = this.cell.getRow().getHeight() - this.cell.getPaddingTop();
        if (this.cell.getRow().getHeight() > this.cell.getHeight() || this.cell.getRowSpan() > 1) {
            if (this.cell.getSettings().getVerticalAlignment() == VerticalAlignment.MIDDLE) {
                float outerHeight = this.cell.getRowSpan() > 1 ? this.cell.getHeight() : this.cell.getRow().getHeight();
                yStartRelative = outerHeight / 2.0f + this.cell.getTextHeight() / 2.0f;
                if (this.cell.getRowSpan() > 1) {
                    float rowSpanAdaption = this.cell.calculateHeightForRowSpan() - this.cell.getRow().getHeight();
                    yStartRelative -= rowSpanAdaption;
                }
            } else if (this.cell.getSettings().getVerticalAlignment() == VerticalAlignment.BOTTOM) {
                yStartRelative = this.cell.getTextHeight() + this.cell.getPaddingBottom();
                if (this.cell.getRowSpan() > 1) {
                    float rowSpanAdaption = this.cell.calculateHeightForRowSpan() - this.cell.getRow().getHeight();
                    yStartRelative -= rowSpanAdaption;
                }
            }
        }
        float yOffset = startY + yStartRelative;
        List<String> lines = this.cell.isWordBreak() ? PdfUtil.getOptimalTextBreakLines(this.cell.getText(), currentFont, currentFontSize, maxWidth) : Collections.singletonList(this.cell.getText());
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            float xOffset = startX + this.cell.getPaddingLeft();
            yOffset -= PdfUtil.getFontHeight(currentFont, currentFontSize) + (i > 0 ? PdfUtil.getFontHeight(currentFont, currentFontSize) * this.cell.getLineSpacing() : 0.0f);
            float textWidth = PdfUtil.getStringWidth(line, currentFont, currentFontSize);
            if (this.cell.getSettings().getHorizontalAlignment() == HorizontalAlignment.RIGHT) {
                xOffset = startX + (this.cell.getWidth() - (textWidth + this.cell.getPaddingRight()));
            } else if (this.cell.getSettings().getHorizontalAlignment() == HorizontalAlignment.CENTER) {
                float diff = (this.cell.getWidth() - textWidth) / 2.0f;
                xOffset = startX + diff;
            } else if (this.cell.getSettings().getHorizontalAlignment() == HorizontalAlignment.JUSTIFY) {
                float charSpacing = 0.0f;
                if (line.length() > 1) {
                    float size = PdfUtil.getStringWidth(line, this.cell.getFont(), this.cell.getFontSize());
                    float free = this.cell.getWidthOfText() - size;
                    if (free > 0.0f) {
                        charSpacing = free / (float)(line.length() - 1);
                    }
                }
                if (i < lines.size() - 1) {
                    drawingContext.getContentStream().setCharacterSpacing(charSpacing);
                }
            }
            this.drawText(line, currentFont, currentFontSize, currentTextColor, xOffset, yOffset, drawingContext.getContentStream());
        }
    }

    protected void drawText(String text, PDFont font, int fontSize, Color color, float x, float y, PDPageContentStream contentStream) throws IOException {
        DrawingUtil.drawText(text, font, fontSize, color, x, y, contentStream);
    }
}

