/*
 * Decompiled with CFR 0.152.
 */
package com.github.valfirst.slf4jtest;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.OverridableProperties;
import com.github.valfirst.slf4jtest.TestLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.event.Level;
import uk.org.lidalia.lang.ThreadLocal;

public final class TestLoggerFactory
implements ILoggerFactory {
    private static volatile TestLoggerFactory INSTANCE = null;
    private final ConcurrentMap<String, TestLogger> loggers = new ConcurrentHashMap<String, TestLogger>();
    private final List<LoggingEvent> allLoggingEvents = Collections.synchronizedList(new ArrayList());
    private final ThreadLocal<List<LoggingEvent>> loggingEvents = new ThreadLocal<List>(ArrayList::new);
    private volatile Level printLevel;
    private volatile Level captureLevel;

    private static Level getLevelProperty(OverridableProperties properties, String propertyKey, String defaultValue) {
        try {
            String printLevelProperty = properties.getProperty(propertyKey, defaultValue);
            if ("OFF".equals(printLevelProperty)) {
                return null;
            }
            return Level.valueOf((String)printLevelProperty);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid level name in property " + propertyKey + " of file slf4jtest.properties or System property slf4jtest." + propertyKey, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TestLoggerFactory getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<TestLoggerFactory> clazz = TestLoggerFactory.class;
        synchronized (TestLoggerFactory.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = TestLoggerFactory.createInstance(OverridableProperties.createUnchecked("slf4jtest"));
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    static TestLoggerFactory createInstance(OverridableProperties properties) {
        Level printLevel = TestLoggerFactory.getLevelProperty(properties, "print.level", "OFF");
        Level captureLevel = TestLoggerFactory.getLevelProperty(properties, "capture.level", "TRACE");
        return new TestLoggerFactory(printLevel, captureLevel);
    }

    public static TestLogger getTestLogger(Class<?> aClass) {
        return TestLoggerFactory.getInstance().getLogger(aClass);
    }

    public static TestLogger getTestLogger(String name) {
        return TestLoggerFactory.getInstance().getLogger(name);
    }

    public static Map<String, TestLogger> getAllTestLoggers() {
        return TestLoggerFactory.getInstance().getAllLoggers();
    }

    public static void clear() {
        TestLoggerFactory.getInstance().clearLoggers();
    }

    public static void clearAll() {
        TestLoggerFactory.getInstance().clearAllLoggers();
    }

    static void reset() {
        TestLoggerFactory.getInstance().doReset();
    }

    public static List<LoggingEvent> getLoggingEvents() {
        return TestLoggerFactory.getInstance().getLoggingEventsFromLoggers();
    }

    public static List<LoggingEvent> getAllLoggingEvents() {
        return TestLoggerFactory.getInstance().getAllLoggingEventsFromLoggers();
    }

    public TestLoggerFactory() {
        this(null, Level.TRACE);
    }

    public TestLoggerFactory(Level printLevel) {
        this(printLevel, Level.TRACE);
    }

    public TestLoggerFactory(Level printLevel, Level captureLevel) {
        this.printLevel = printLevel;
        this.captureLevel = captureLevel;
    }

    public Level getPrintLevel() {
        return this.printLevel;
    }

    public Level getCaptureLevel() {
        return this.captureLevel;
    }

    public Map<String, TestLogger> getAllLoggers() {
        return Collections.unmodifiableMap(new HashMap<String, TestLogger>(this.loggers));
    }

    public TestLogger getLogger(Class<?> aClass) {
        return this.getLogger(aClass.getName());
    }

    public TestLogger getLogger(String name) {
        return this.loggers.computeIfAbsent(name, nm -> new TestLogger((String)nm, this));
    }

    public void clearLoggers() {
        for (TestLogger testLogger : this.loggers.values()) {
            testLogger.clear();
        }
        this.loggingEvents.get().clear();
    }

    public void clearAllLoggers() {
        for (TestLogger testLogger : this.loggers.values()) {
            testLogger.clearAll();
        }
        this.loggingEvents.reset();
        this.allLoggingEvents.clear();
    }

    void doReset() {
        this.clearAllLoggers();
        this.loggers.clear();
    }

    public List<LoggingEvent> getLoggingEventsFromLoggers() {
        return Collections.unmodifiableList(new ArrayList(this.loggingEvents.get()));
    }

    public List<LoggingEvent> getAllLoggingEventsFromLoggers() {
        return this.allLoggingEvents;
    }

    void addLoggingEvent(LoggingEvent event) {
        this.loggingEvents.get().add(event);
        this.allLoggingEvents.add(event);
    }

    public void setPrintLevel(Level printLevel) {
        this.printLevel = printLevel;
    }

    public void setCaptureLevel(Level captureLevel) {
        this.captureLevel = captureLevel;
    }
}

