/*
 * Decompiled with CFR 0.152.
 */
package com.github.valfirst.slf4jtest;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import com.github.valfirst.slf4jtest.TestLoggingEventBuilder;
import com.github.valfirst.slf4jtest.TestMDCAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;
import org.slf4j.event.Level;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LoggingEventAware;
import org.slf4j.spi.LoggingEventBuilder;
import uk.org.lidalia.lang.ThreadLocal;

public class TestLogger
implements Logger,
LoggingEventAware {
    private final String name;
    private final TestLoggerFactory testLoggerFactory;
    private final ThreadLocal<List<LoggingEvent>> loggingEvents = new ThreadLocal<List>(ArrayList::new);
    private final List<LoggingEvent> allLoggingEvents = new CopyOnWriteArrayList<LoggingEvent>();
    private static final Set<Level> allLevels = Collections.unmodifiableSet(EnumSet.allOf(Level.class));
    private volatile ThreadLocal<Set<Level>> enabledLevels = new ThreadLocal<Set<Level>>(allLevels);

    TestLogger(String name, TestLoggerFactory testLoggerFactory) {
        this.name = name;
        this.testLoggerFactory = testLoggerFactory;
    }

    public String getName() {
        return this.name;
    }

    public LoggingEventBuilder makeLoggingEventBuilder(Level level) {
        return new TestLoggingEventBuilder(this, level);
    }

    public void clear() {
        this.loggingEvents.get().clear();
        this.enabledLevels.set(allLevels);
    }

    public void clearAll() {
        this.allLoggingEvents.clear();
        this.loggingEvents.reset();
        this.enabledLevels.reset();
        this.enabledLevels = new ThreadLocal<Set<Level>>(allLevels);
    }

    public List<LoggingEvent> getLoggingEvents() {
        return Collections.unmodifiableList(new ArrayList(this.loggingEvents.get()));
    }

    public List<LoggingEvent> getAllLoggingEvents() {
        return Collections.unmodifiableList(new ArrayList<LoggingEvent>(this.allLoggingEvents));
    }

    public boolean isTraceEnabled() {
        return this.enabledLevels.get().contains(Level.TRACE);
    }

    public void trace(String message) {
        this.log(Level.TRACE, message, new Object[0]);
    }

    public void trace(String format, Object arg) {
        this.log(Level.TRACE, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.log(Level.TRACE, format, arg1, arg2);
    }

    public void trace(String format, Object ... args) {
        this.log(Level.TRACE, format, args);
    }

    public void trace(String msg, Throwable throwable) {
        this.log(Level.TRACE, msg, throwable);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.enabledLevels.get().contains(Level.TRACE);
    }

    public void trace(Marker marker, String msg) {
        this.log(Level.TRACE, marker, msg, new Object[0]);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.log(Level.TRACE, marker, format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.log(Level.TRACE, marker, format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... args) {
        this.log(Level.TRACE, marker, format, args);
    }

    public void trace(Marker marker, String msg, Throwable throwable) {
        this.log(Level.TRACE, marker, msg, throwable);
    }

    public boolean isDebugEnabled() {
        return this.enabledLevels.get().contains(Level.DEBUG);
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message, new Object[0]);
    }

    public void debug(String format, Object arg) {
        this.log(Level.DEBUG, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.log(Level.DEBUG, format, arg1, arg2);
    }

    public void debug(String format, Object ... args) {
        this.log(Level.DEBUG, format, args);
    }

    public void debug(String msg, Throwable throwable) {
        this.log(Level.DEBUG, msg, throwable);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.enabledLevels.get().contains(Level.DEBUG);
    }

    public void debug(Marker marker, String msg) {
        this.log(Level.DEBUG, marker, msg, new Object[0]);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.log(Level.DEBUG, marker, format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.log(Level.DEBUG, marker, format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... args) {
        this.log(Level.DEBUG, marker, format, args);
    }

    public void debug(Marker marker, String msg, Throwable throwable) {
        this.log(Level.DEBUG, marker, msg, throwable);
    }

    public boolean isInfoEnabled() {
        return this.enabledLevels.get().contains(Level.INFO);
    }

    public void info(String message) {
        this.log(Level.INFO, message, new Object[0]);
    }

    public void info(String format, Object arg) {
        this.log(Level.INFO, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.log(Level.INFO, format, arg1, arg2);
    }

    public void info(String format, Object ... args) {
        this.log(Level.INFO, format, args);
    }

    public void info(String msg, Throwable throwable) {
        this.log(Level.INFO, msg, throwable);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.enabledLevels.get().contains(Level.INFO);
    }

    public void info(Marker marker, String msg) {
        this.log(Level.INFO, marker, msg, new Object[0]);
    }

    public void info(Marker marker, String format, Object arg) {
        this.log(Level.INFO, marker, format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.log(Level.INFO, marker, format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... args) {
        this.log(Level.INFO, marker, format, args);
    }

    public void info(Marker marker, String msg, Throwable throwable) {
        this.log(Level.INFO, marker, msg, throwable);
    }

    public boolean isWarnEnabled() {
        return this.enabledLevels.get().contains(Level.WARN);
    }

    public void warn(String message) {
        this.log(Level.WARN, message, new Object[0]);
    }

    public void warn(String format, Object arg) {
        this.log(Level.WARN, format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.log(Level.WARN, format, arg1, arg2);
    }

    public void warn(String format, Object ... args) {
        this.log(Level.WARN, format, args);
    }

    public void warn(String msg, Throwable throwable) {
        this.log(Level.WARN, msg, throwable);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.enabledLevels.get().contains(Level.WARN);
    }

    public void warn(Marker marker, String msg) {
        this.log(Level.WARN, marker, msg, new Object[0]);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.log(Level.WARN, marker, format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.log(Level.WARN, marker, format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... args) {
        this.log(Level.WARN, marker, format, args);
    }

    public void warn(Marker marker, String msg, Throwable throwable) {
        this.log(Level.WARN, marker, msg, throwable);
    }

    public boolean isErrorEnabled() {
        return this.enabledLevels.get().contains(Level.ERROR);
    }

    public void error(String message) {
        this.log(Level.ERROR, message, new Object[0]);
    }

    public void error(String format, Object arg) {
        this.log(Level.ERROR, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.log(Level.ERROR, format, arg1, arg2);
    }

    public void error(String format, Object ... args) {
        this.log(Level.ERROR, format, args);
    }

    public void error(String msg, Throwable throwable) {
        this.log(Level.ERROR, msg, throwable);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.enabledLevels.get().contains(Level.ERROR);
    }

    public void error(Marker marker, String msg) {
        this.log(Level.ERROR, marker, msg, new Object[0]);
    }

    public void error(Marker marker, String format, Object arg) {
        this.log(Level.ERROR, marker, format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.log(Level.ERROR, marker, format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... args) {
        this.log(Level.ERROR, marker, format, args);
    }

    public void error(Marker marker, String msg, Throwable throwable) {
        this.log(Level.ERROR, marker, msg, throwable);
    }

    public void log(org.slf4j.event.LoggingEvent event) {
        if (this.enabledByGlobalCaptureLevel(event.getLevel())) {
            this.addLoggingEvent(LoggingEvent.fromSlf4jEvent(event, this.mdc()));
        }
    }

    private void log(Level level, String format, Object ... args) {
        this.log(level, format, Optional.empty(), args);
    }

    private void log(Level level, String msg, Throwable throwable) {
        this.addLoggingEvent(level, Optional.empty(), Optional.ofNullable(throwable), msg, new Object[0]);
    }

    private void log(Level level, Marker marker, String format, Object ... args) {
        this.log(level, format, Optional.ofNullable(marker), args);
    }

    private void log(Level level, Marker marker, String msg, Throwable throwable) {
        this.addLoggingEvent(level, Optional.ofNullable(marker), Optional.ofNullable(throwable), msg, new Object[0]);
    }

    private void log(Level level, String format, Optional<Marker> marker, Object[] args) {
        FormattingTuple formattedArgs = MessageFormatter.arrayFormat((String)format, (Object[])args);
        this.addLoggingEvent(level, marker, Optional.ofNullable(formattedArgs.getThrowable()), format, formattedArgs.getArgArray());
    }

    private void addLoggingEvent(Level level, Optional<Marker> marker, Optional<Throwable> throwable, String format, Object ... args) {
        this.addLoggingEvent(level, marker.map(Collections::singletonList).orElseGet(Collections::emptyList), Collections.emptyList(), throwable, format, args);
    }

    private void addLoggingEvent(Level level, List<Marker> markers, List<KeyValuePair> keyValuePairs, Optional<Throwable> throwable, String format, Object ... args) {
        if (this.enabledLevels.get().contains(level) && this.enabledByGlobalCaptureLevel(level)) {
            LoggingEvent event = new LoggingEvent(Optional.of(this), level, this.mdc(), markers, keyValuePairs, throwable, format, args);
            this.addLoggingEvent(event);
        }
    }

    private void addLoggingEvent(LoggingEvent event) {
        this.allLoggingEvents.add(event);
        this.loggingEvents.get().add(event);
        this.testLoggerFactory.addLoggingEvent(event);
        this.optionallyPrint(event);
    }

    private boolean enabledByGlobalCaptureLevel(Level level) {
        Level captureLevel = this.testLoggerFactory.getCaptureLevel();
        return captureLevel != null && captureLevel.compareTo((Enum)level) >= 0;
    }

    private Map<String, String> mdc() {
        return TestMDCAdapter.getInstance().getContextMap();
    }

    private void optionallyPrint(LoggingEvent event) {
        Level printLevel = this.testLoggerFactory.getPrintLevel();
        if (printLevel != null && printLevel.compareTo((Enum)event.getLevel()) >= 0) {
            event.print();
        }
    }

    public Set<Level> getEnabledLevels() {
        return this.enabledLevels.get();
    }

    public void setEnabledLevels(Collection<Level> enabledLevels) {
        this.enabledLevels.set(this.setOfLevels(enabledLevels));
    }

    public void setEnabledLevels(Level ... enabledLevels) {
        this.setEnabledLevels(Arrays.asList(enabledLevels));
    }

    public void setEnabledLevelsForAllThreads(Collection<Level> enabledLevelsForAllThreads) {
        this.enabledLevels = new ThreadLocal<Set<Level>>(this.setOfLevels(enabledLevelsForAllThreads));
    }

    public void setEnabledLevelsForAllThreads(Level ... enabledLevelsForAllThreads) {
        this.setEnabledLevelsForAllThreads(Arrays.asList(enabledLevelsForAllThreads));
    }

    private Set<Level> setOfLevels(Collection<Level> levels) {
        return levels.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(EnumSet.copyOf(levels));
    }
}

