/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitm.keys;

import com.browserup.bup.mitm.exception.KeyGeneratorException;
import com.browserup.bup.mitm.keys.KeyGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.ECGenParameterSpec;

public class ECKeyGenerator
implements KeyGenerator {
    private static final String EC_KEY_GEN_ALGORITHM = "EC";
    private static final String DEFAULT_NAMED_CURVE = "secp256r1";
    private final String namedCurve;

    public ECKeyGenerator() {
        this.namedCurve = DEFAULT_NAMED_CURVE;
    }

    public ECKeyGenerator(String namedCurve) {
        this.namedCurve = namedCurve;
    }

    @Override
    public KeyPair generate() {
        KeyPairGenerator generator;
        try {
            generator = KeyPairGenerator.getInstance(EC_KEY_GEN_ALGORITHM);
            ECGenParameterSpec ecName = new ECGenParameterSpec(this.namedCurve);
            generator.initialize(ecName);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new KeyGeneratorException("Unable to generate EC public/private key pair using named curve: " + this.namedCurve, e);
        }
        return generator.generateKeyPair();
    }

    public String toString() {
        return "EC (" + this.namedCurve + ")";
    }
}

