/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitm;

import com.browserup.bup.mitm.CertificateAndKey;
import com.browserup.bup.mitm.CertificateAndKeySource;
import com.browserup.bup.mitm.exception.CertificateSourceException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;

public class KeyStoreCertificateSource
implements CertificateAndKeySource {
    private final KeyStore keyStore;
    private final String keyStorePassword;
    private final String privateKeyAlias;

    public KeyStoreCertificateSource(KeyStore keyStore, String privateKeyAlias, String keyStorePassword) {
        if (keyStore == null) {
            throw new IllegalArgumentException("KeyStore cannot be null");
        }
        if (privateKeyAlias == null) {
            throw new IllegalArgumentException("Private key alias cannot be null");
        }
        if (keyStorePassword == null) {
            throw new IllegalArgumentException("KeyStore password cannot be null");
        }
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.privateKeyAlias = privateKeyAlias;
    }

    @Override
    public CertificateAndKey load() {
        try {
            KeyStore.Entry entry;
            try {
                entry = this.keyStore.getEntry(this.privateKeyAlias, new KeyStore.PasswordProtection(this.keyStorePassword.toCharArray()));
            }
            catch (UnrecoverableEntryException e) {
                throw new CertificateSourceException("Unable to load private key with alias " + this.privateKeyAlias + " from KeyStore. Verify the KeyStore password is correct.", e);
            }
            if (entry == null) {
                throw new CertificateSourceException("Unable to find entry in keystore with alias: " + this.privateKeyAlias);
            }
            if (!(entry instanceof KeyStore.PrivateKeyEntry)) {
                throw new CertificateSourceException("Entry in KeyStore with alias " + this.privateKeyAlias + " did not contain a private key entry");
            }
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            if (!(privateKeyEntry.getCertificate() instanceof X509Certificate)) {
                throw new CertificateSourceException("Certificate for private key in KeyStore was not an X509Certificate. Private key alias: " + this.privateKeyAlias + ". Certificate type: " + (privateKeyEntry.getCertificate() != null ? privateKeyEntry.getCertificate().getClass().getName() : null));
            }
            X509Certificate x509Certificate = (X509Certificate)privateKeyEntry.getCertificate();
            return new CertificateAndKey(x509Certificate, privateKey);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new CertificateSourceException("Error accessing keyStore", e);
        }
    }
}

