/*
 * Decompiled with CFR 0.152.
 */
package me.vponomarenko.injectionmanager;

import android.app.Application;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.vponomarenko.injectionmanager.ComponentsController;
import me.vponomarenko.injectionmanager.ComponentsStore;
import me.vponomarenko.injectionmanager.IHasComponent;
import me.vponomarenko.injectionmanager.callbacks.ILifecycleListener;
import me.vponomarenko.injectionmanager.customlifecycle.StoredComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\f\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u000f\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\fJ\u0016\u0010\u0010\u001a\u0002H\n\"\u0006\b\u0000\u0010\n\u0018\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0010\u001a\u00020\u00012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00140\u0013J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lme/vponomarenko/injectionmanager/InjectionManager;", "", "lifecycleListener", "Lme/vponomarenko/injectionmanager/callbacks/ILifecycleListener;", "(Lme/vponomarenko/injectionmanager/callbacks/ILifecycleListener;)V", "componentsController", "Lme/vponomarenko/injectionmanager/ComponentsController;", "componentsStore", "Lme/vponomarenko/injectionmanager/ComponentsStore;", "bindComponent", "T", "owner", "Lme/vponomarenko/injectionmanager/IHasComponent;", "(Lme/vponomarenko/injectionmanager/IHasComponent;)Ljava/lang/Object;", "bindComponentToCustomLifecycle", "Lme/vponomarenko/injectionmanager/customlifecycle/StoredComponent;", "findComponent", "()Ljava/lang/Object;", "predicate", "Lkotlin/Function1;", "", "init", "", "app", "Landroid/app/Application;", "injectionmanager_release"})
public final class InjectionManager {
    private final ComponentsStore componentsStore;
    private final ComponentsController componentsController;

    public final void init(@NotNull Application app) {
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        this.componentsController.addLifecycleCallbackListeners(app);
    }

    public final <T> T bindComponent(@NotNull IHasComponent<? extends T> owner) {
        Intrinsics.checkParameterIsNotNull(owner, (String)"owner");
        return this.componentsController.bindComponent(owner);
    }

    @NotNull
    public final <T> StoredComponent<T> bindComponentToCustomLifecycle(@NotNull IHasComponent<? extends T> owner) {
        Intrinsics.checkParameterIsNotNull(owner, (String)"owner");
        return new StoredComponent<T>(this.bindComponent(owner), this.componentsController.getCustomLifecycleForKey(owner.getComponentKey()));
    }

    private final <T> T findComponent() {
        Intrinsics.needClassReification();
        Function1<Object, Boolean> predicate2 = new Function1<Object, Boolean>(){

            @NotNull
            public Boolean invoke(@NotNull Object component) {
                Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
                Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                return component instanceof Object;
            }

            @NotNull
            public String toString() {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                String string = Object.class.getSimpleName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"T::class.java.simpleName");
                return string;
            }
        };
        Object object = this.findComponent((Function1<Object, Boolean>)((Function1)predicate2));
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)object;
    }

    @NotNull
    public final Object findComponent(@NotNull Function1<Object, Boolean> predicate2) {
        Intrinsics.checkParameterIsNotNull(predicate2, (String)"predicate");
        return this.componentsStore.findComponent(predicate2);
    }

    public InjectionManager(@NotNull ILifecycleListener lifecycleListener) {
        Intrinsics.checkParameterIsNotNull((Object)lifecycleListener, (String)"lifecycleListener");
        this.componentsStore = new ComponentsStore();
        this.componentsController = new ComponentsController(this.componentsStore, lifecycleListener);
    }
}

