/*
 * Decompiled with CFR 0.152.
 */
package com.github.vacxe.phonemask;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;
import com.github.vacxe.phonemask.Utils;
import com.github.vacxe.phonemask.ValueListener;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PhoneMaskWatcher
implements TextWatcher {
    private final String mask;
    private final String region;
    private final ValueListener valueListener;
    private final Pattern maskPattern;
    private final EditText editText;
    private String result = "";
    private EditState state = EditState.IDLE;
    private Integer cursorPosition;
    private Integer cursorShifting;
    private String phoneString = "";

    PhoneMaskWatcher(String mask, String region, ValueListener valueListener, String maskSymbol, EditText editText) {
        this.mask = mask;
        this.region = region;
        this.valueListener = valueListener;
        this.maskPattern = Pattern.compile(maskSymbol);
        this.editText = editText;
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        if (this.state == EditState.IDLE) {
            this.cursorShifting = s.length();
        }
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        String value = s.toString();
        if (this.state == EditState.RELEASE) {
            this.cursorShifting = s.length() - this.cursorShifting;
            this.cursorPosition = this.cursorPosition + this.cursorShifting;
            if (this.cursorShifting > 0) {
                if (this.cursorPosition < value.length()) {
                    Integer n = this.cursorPosition;
                    Integer n2 = this.cursorPosition = Integer.valueOf(this.cursorPosition - 1);
                    if (!Character.isDigit(value.charAt(this.cursorPosition))) {
                        n = this.cursorPosition;
                        n2 = this.cursorPosition = Integer.valueOf(this.cursorPosition + 1);
                    }
                }
            } else {
                Integer n = this.cursorPosition;
                Integer n3 = this.cursorPosition = Integer.valueOf(this.cursorPosition + 1);
            }
            this.editText.setSelection(Math.max(0, Math.min(this.cursorPosition, value.length())));
            this.state = EditState.IDLE;
            return;
        }
        if (this.state == EditState.IDLE) {
            if (s.toString().isEmpty()) {
                this.phoneString = "";
                this.cursorPosition = 0;
                return;
            }
            this.cursorPosition = this.editText.getSelectionStart();
            String rawString = value.replace(this.region, "");
            rawString = Utils.notDigitRegex.matcher(rawString).replaceAll("");
            LinkedList<Character> charsQueue = new LinkedList<Character>();
            for (char c : rawString.toCharArray()) {
                charsQueue.add(Character.valueOf(c));
            }
            StringBuilder rawMaskBuilder = new StringBuilder(this.region + this.mask);
            Matcher matcher = this.maskPattern.matcher(this.region + this.mask);
            while (matcher.find()) {
                int start = matcher.start();
                if (!charsQueue.isEmpty()) {
                    rawMaskBuilder.replace(start, start + 1, ((Character)charsQueue.poll()).toString());
                    if (!charsQueue.isEmpty()) continue;
                    this.result = rawMaskBuilder.substring(0, start + 1);
                    break;
                }
                this.result = rawMaskBuilder.substring(0, start);
                break;
            }
            String phone = Utils.notDigitRegex.matcher(rawMaskBuilder.toString()).replaceAll("");
            this.phoneString = "+" + phone;
            if (this.valueListener != null) {
                this.valueListener.onPhoneChanged(this.phoneString);
            }
            this.state = EditState.EDIT;
        }
        switch (this.state) {
            case EDIT: {
                this.state = EditState.CLEAR;
                s.clear();
                break;
            }
            case CLEAR: {
                this.state = EditState.RELEASE;
                s.append((CharSequence)this.result, 0, this.result.length());
                break;
            }
        }
    }

    public String getPhone() {
        return this.phoneString;
    }

    static enum EditState {
        IDLE,
        EDIT,
        CLEAR,
        RELEASE;

    }
}

