/*
 * Decompiled with CFR 0.152.
 */
package com.github.vacxe.phonemask;

import android.text.Editable;
import android.text.TextWatcher;
import com.github.vacxe.phonemask.ValueListener;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PhoneMaskWatcher
implements TextWatcher {
    private final String mask;
    private final String region;
    private final ValueListener valueListener;
    private String result = "";
    private EditState state = EditState.IDLE;
    private Pattern notDigitRegex = Pattern.compile("[^\\d]+");

    PhoneMaskWatcher(String mask, String region, ValueListener valueListener) {
        this.mask = mask;
        this.region = region;
        this.valueListener = valueListener;
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        String value = s.toString();
        if (this.state == EditState.RELEASE) {
            this.state = EditState.IDLE;
            return;
        }
        if (this.state == EditState.IDLE) {
            String rawString = value.replace(this.region, "");
            rawString = this.notDigitRegex.matcher(rawString).replaceAll("");
            LinkedList<Character> charsQueue = new LinkedList<Character>();
            for (char c : rawString.toCharArray()) {
                charsQueue.add(Character.valueOf(c));
            }
            StringBuilder rawMaskBuilder = new StringBuilder(this.region + this.mask);
            Pattern pattern = Pattern.compile("#");
            Matcher matcher = pattern.matcher(this.region + this.mask);
            while (matcher.find()) {
                int start = matcher.start();
                if (!charsQueue.isEmpty()) {
                    rawMaskBuilder.replace(start, start + 1, ((Character)charsQueue.poll()).toString());
                    if (!charsQueue.isEmpty()) continue;
                    this.result = rawMaskBuilder.substring(0, start + 1);
                    break;
                }
                this.result = rawMaskBuilder.substring(0, start);
                break;
            }
            String phone = this.notDigitRegex.matcher(rawMaskBuilder.toString()).replaceAll("");
            this.valueListener.onPhoneChanged("+" + phone);
            this.state = EditState.EDIT;
        }
        switch (this.state) {
            case EDIT: {
                this.state = EditState.CLEAR;
                s.clear();
                break;
            }
            case CLEAR: {
                this.state = EditState.RELEASE;
                s.append((CharSequence)this.result, 0, this.result.length());
                break;
            }
        }
    }

    static enum EditState {
        IDLE,
        EDIT,
        CLEAR,
        RELEASE;

    }
}

