/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jdbcdslog.LogUtils;
import org.jdbcdslog.RdbmsSpecifics;

public class OracleRdbmsSpecifics
implements RdbmsSpecifics {
    public String formatParameter(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            String text = LogUtils.replaceEach((String)object, new String[]{"\\", "$", "'", "&", "\r", "\n", "\t"}, new String[]{"\\\\", "\\$", "''", "'||chr(38)||'", "", "'||chr(10)||'", "'||chr(9)||'"});
            return "'" + text + "'";
        }
        if (object instanceof Timestamp) {
            return "to_timestamp('" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(object) + "', 'yyyy-MM-dd hh24:mi:ss.ff3')";
        }
        if (object instanceof Date) {
            return "to_date('" + new SimpleDateFormat("yyyy-MM-dd").format(object) + "', 'yyyy-MM-dd')";
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? "Y" : "N";
        }
        return object.toString();
    }
}

