/*
 * Decompiled with CFR 0.152.
 */
package me.uport.sdk.signer;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import me.uport.sdk.core.Signer;
import org.jetbrains.annotations.NotNull;
import org.kethereum.crypto.ECKeyPair;
import org.kethereum.crypto.KeysKt;
import org.kethereum.crypto.SignKt;
import org.kethereum.extensions.BigIntegerKt;
import org.kethereum.model.SignatureData;
import org.kethereum.model.Transaction;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016JP\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2>\u0010\n\u001a:\u0012\u001b\u0012\u0019\u0018\u00010\fj\u0004\u0018\u0001`\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00070\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/uport/sdk/signer/SimpleSigner;", "Lme/uport/sdk/core/Signer;", "privateKey", "", "(Ljava/lang/String;)V", "getAddress", "signMessage", "", "rawMessage", "", "callback", "Lkotlin/Function2;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Lkotlin/ParameterName;", "name", "err", "Lorg/kethereum/model/SignatureData;", "sigData", "sdk_release"})
public final class SimpleSigner
implements Signer {
    private final String privateKey;

    @NotNull
    public String getAddress() {
        return KeysKt.getAddress((ECKeyPair)ECKeyPair.Companion.create(BigIntegerKt.hexToBigInteger((String)this.privateKey)));
    }

    public void signMessage(@NotNull byte[] rawMessage, @NotNull Function2<? super Exception, ? super SignatureData, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)rawMessage, (String)"rawMessage");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        try {
            ECKeyPair keyPair = ECKeyPair.Companion.create(BigIntegerKt.hexToBigInteger((String)this.privateKey));
            SignatureData sigData = SignKt.signMessage((ECKeyPair)keyPair, (byte[])rawMessage);
            callback.invoke(null, (Object)sigData);
        }
        catch (Exception ex) {
            callback.invoke((Object)ex, (Object)new SignatureData(null, null, 0, 7, null));
        }
    }

    public SimpleSigner(@NotNull String privateKey) {
        Intrinsics.checkParameterIsNotNull((Object)privateKey, (String)"privateKey");
        this.privateKey = privateKey;
    }

    public void signRawTx(@NotNull Transaction unsignedTx, @NotNull Function2<? super Exception, ? super byte[], Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)unsignedTx, (String)"unsignedTx");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Signer.DefaultImpls.signRawTx((Signer)this, (Transaction)unsignedTx, callback);
    }
}

