/*
 * Decompiled with CFR 0.152.
 */
package me.uport.sdk;

import android.content.SharedPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.uport.sdk.AccountHolder;
import me.uport.sdk.AccountStorage;
import me.uport.sdk.SharedPrefsAccountStorage$WhenMappings;
import me.uport.sdk.identity.Account;
import me.uport.sdk.identity.AccountType;
import me.uport.sdk.identity.HDAccount;
import me.uport.sdk.identity.MetaIdentityAccount;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\u0016\u0010\u001d\u001a\u00020\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001fH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lme/uport/sdk/SharedPrefsAccountStorage;", "Lme/uport/sdk/AccountStorage;", "prefs", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "accounts", "", "", "Lme/uport/sdk/AccountHolder;", "all", "", "Lme/uport/sdk/identity/Account;", "buildAccountHolder", "account", "delete", "", "handle", "fetchAccountFromHolder", "holder", "fetchAllAccounts", "get", "getDefaultAccount", "persist", "persistDefault", "serializedAccountHolder", "setAsDefault", "accountHandle", "upsert", "newAcc", "upsertAll", "list", "", "Companion", "sdk_release"})
public final class SharedPrefsAccountStorage
implements AccountStorage {
    private final Map<String, AccountHolder> accounts;
    private final SharedPreferences prefs;
    private static final String KEY_ACCOUNTS = "accounts";
    private static final String KEY_DEFAULT_ACCOUNT = "default_account";
    public static final Companion Companion = new Companion(null);

    @Override
    public void upsert(@NotNull Account newAcc) {
        Intrinsics.checkParameterIsNotNull((Object)newAcc, (String)"newAcc");
        this.accounts.put(newAcc.getHandle(), this.buildAccountHolder(newAcc));
        this.persist();
    }

    @Override
    public void upsertAll(@NotNull Collection<? extends Account> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Account it = (Account)element$iv;
            boolean bl = false;
            this.accounts.put(it.getHandle(), this.buildAccountHolder(it));
        }
        this.persist();
    }

    @Override
    @Nullable
    public Account get(@NotNull String handle) {
        Intrinsics.checkParameterIsNotNull((Object)handle, (String)"handle");
        AccountHolder holder = this.accounts.get(handle);
        return this.fetchAccountFromHolder(holder);
    }

    @Override
    public void delete(@NotNull String handle) {
        Intrinsics.checkParameterIsNotNull((Object)handle, (String)"handle");
        this.accounts.remove(handle);
        Account account = this.getDefaultAccount();
        if (StringsKt.equals$default((String)(account != null ? account.getHandle() : null), (String)handle, (boolean)false, (int)2, null)) {
            this.persistDefault("");
        }
        this.persist();
    }

    @Override
    @NotNull
    public List<Account> all() {
        return this.fetchAllAccounts();
    }

    @Override
    public void setAsDefault(@NotNull String accountHandle) {
        Intrinsics.checkParameterIsNotNull((Object)accountHandle, (String)"accountHandle");
        this.persistDefault(accountHandle);
    }

    @Override
    @Nullable
    public Account getDefaultAccount() {
        String string = this.prefs.getString(KEY_DEFAULT_ACCOUNT, "");
        if (string == null) {
            string = "";
        }
        String accountHandle = string;
        AccountHolder defaultAccountHolder = this.accounts.get(accountHandle);
        if (defaultAccountHolder != null && Intrinsics.areEqual((Object)defaultAccountHolder, (Object)AccountHolder.Companion.getBlank()) ^ true) {
            return this.fetchAccountFromHolder(defaultAccountHolder);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void persist() {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.accounts.values();
        String string = KEY_ACCOUNTS;
        SharedPreferences.Editor editor = this.prefs.edit();
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AccountHolder accountHolder = (AccountHolder)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = AccountHolder.toJson$default((AccountHolder)it, false, 1, null);
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        editor.putStringSet(string, CollectionsKt.toSet((Iterable)collection)).apply();
    }

    private final void persistDefault(String serializedAccountHolder) {
        this.prefs.edit().putString(KEY_DEFAULT_ACCOUNT, serializedAccountHolder).apply();
    }

    private final AccountHolder buildAccountHolder(Account account) {
        String string;
        switch (SharedPrefsAccountStorage$WhenMappings.$EnumSwitchMapping$0[account.getType().ordinal()]) {
            case 1: {
                Account account2 = account;
                if (account2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type me.uport.sdk.identity.HDAccount");
                }
                string = HDAccount.toJson$default((HDAccount)((HDAccount)account2), (boolean)false, (int)1, null);
                break;
            }
            case 2: {
                Account account3 = account;
                if (account3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type me.uport.sdk.identity.MetaIdentityAccount");
                }
                string = MetaIdentityAccount.toJson$default((MetaIdentityAccount)((MetaIdentityAccount)account3), (boolean)false, (int)1, null);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Storage not supported AccountType " + account.getType());
            }
        }
        String acc = string;
        return new AccountHolder(acc, account.getType().toString());
    }

    private final Account fetchAccountFromHolder(AccountHolder holder) {
        String string;
        AccountHolder accountHolder = holder;
        String string2 = string = accountHolder != null ? accountHolder.getType() : null;
        return Intrinsics.areEqual((Object)string, (Object)AccountType.HDKeyPair.toString()) ? (Account)HDAccount.Companion.fromJson(holder.getAccount()) : (Intrinsics.areEqual((Object)string, (Object)AccountType.MetaIdentityManager.toString()) ? (Account)MetaIdentityAccount.Companion.fromJson(holder.getAccount()) : null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Account> fetchAllAccounts() {
        void $this$mapTo$iv$iv;
        Map<String, AccountHolder> $this$map$iv = this.accounts;
        boolean $i$f$map = false;
        Map<String, AccountHolder> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Account account = this.fetchAccountFromHolder((AccountHolder)it.getValue());
            collection.add(account);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    public SharedPrefsAccountStorage(@NotNull SharedPreferences prefs) {
        Intrinsics.checkParameterIsNotNull((Object)prefs, (String)"prefs");
        this.prefs = prefs;
        SharedPrefsAccountStorage sharedPrefsAccountStorage = this;
        boolean bl = false;
        Map map = MapsKt.emptyMap();
        sharedPrefsAccountStorage.accounts = MapsKt.toMutableMap((Map)map);
        Set set = this.prefs.getStringSet(KEY_ACCOUNTS, SetsKt.emptySet());
        boolean bl2 = false;
        Set set2 = set;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AccountHolder accountHolder;
            AccountHolder accountHolder2;
            String serialized = (String)element$iv;
            boolean bl3 = false;
            try {
                String string = serialized;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"serialized");
                accountHolder2 = AccountHolder.Companion.fromJson(string);
            }
            catch (Exception ex) {
                accountHolder2 = null;
            }
            accountHolder2 = accountHolder = accountHolder2;
            boolean bl4 = false;
            boolean bl5 = false;
            AccountHolder it = accountHolder2;
            boolean bl6 = false;
            Account account = this.fetchAccountFromHolder(accountHolder);
            if (account == null) continue;
            this.upsert(account);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/uport/sdk/SharedPrefsAccountStorage$Companion;", "", "()V", "KEY_ACCOUNTS", "", "KEY_DEFAULT_ACCOUNT", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

