/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.core.env.PropertySource;

public interface EncryptablePropertySource<T>
extends OriginLookup<String> {
    public PropertySource<T> getDelegate();

    default public Object getProperty(String name) {
        return this.getDelegate().getProperty(name);
    }

    default public void refresh() {
        if (this.getDelegate() instanceof EncryptablePropertySource) {
            ((EncryptablePropertySource)this.getDelegate()).refresh();
        }
    }

    default public Object getProperty(EncryptablePropertyResolver resolver, EncryptablePropertyFilter filter, PropertySource<T> source, String name) {
        Object value = source.getProperty(name);
        if (value != null && filter.shouldInclude(source, name) && value instanceof String) {
            String stringValue = String.valueOf(value);
            return resolver.resolvePropertyValue(stringValue);
        }
        return value;
    }

    default public Origin getOrigin(String key) {
        if (this.getDelegate() instanceof OriginLookup) {
            return ((OriginLookup)this.getDelegate()).getOrigin((Object)key);
        }
        return null;
    }

    default public boolean isImmutable() {
        if (this.getDelegate() instanceof OriginLookup) {
            return ((OriginLookup)this.getDelegate()).isImmutable();
        }
        return super.isImmutable();
    }

    default public String getPrefix() {
        if (this.getDelegate() instanceof OriginLookup) {
            return ((OriginLookup)this.getDelegate()).getPrefix();
        }
        return super.getPrefix();
    }
}

