/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public class EncryptableEnumerablePropertySourceWrapper<T>
extends EnumerablePropertySource<T>
implements EncryptablePropertySource<T> {
    private final EnumerablePropertySource<T> delegate;
    private final StringEncryptor encryptor;

    public EncryptableEnumerablePropertySourceWrapper(EnumerablePropertySource<T> delegate, StringEncryptor encryptor) {
        super(delegate.getName(), delegate.getSource());
        Assert.notNull(delegate, (String)"PropertySource delegate cannot be null");
        Assert.notNull((Object)encryptor, (String)"StringEncryptor cannot be null");
        this.delegate = delegate;
        this.encryptor = encryptor;
    }

    public Object getProperty(String name) {
        return new EncryptablePropertySource.DefaultMethods<T>().getProperty(this.encryptor, (PropertySource<T>)this.delegate, name);
    }

    public String[] getPropertyNames() {
        return this.delegate.getPropertyNames();
    }
}

