/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot;

import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class StringEncryptorConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(StringEncryptorConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={StringEncryptor.class})
    public StringEncryptor stringEncryptor(Environment environment) {
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword(this.getRequiredProperty(environment, "jasypt.encryptor.password"));
        config.setAlgorithm(this.getProperty(environment, "jasypt.encryptor.algorithm", "PBEWithMD5AndDES"));
        config.setKeyObtentionIterations(this.getProperty(environment, "jasypt.encryptor.keyObtentionIterations", "1000"));
        config.setPoolSize(this.getProperty(environment, "jasypt.encryptor.poolSize", "1"));
        config.setProviderName(this.getProperty(environment, "jasypt.encryptor.providerName", "SunJCE"));
        config.setSaltGeneratorClassName(this.getProperty(environment, "jasypt.encryptor.saltGeneratorClassname", "org.jasypt.salt.RandomSaltGenerator"));
        config.setStringOutputType(this.getProperty(environment, "jasypt.encryptor.stringOutputType", "base64"));
        encryptor.setConfig((PBEConfig)config);
        return encryptor;
    }

    private String getProperty(Environment environment, String key, String defaultValue) {
        if (!this.propertyExists(environment, key)) {
            LOG.info("Encryptor config not found for property {}, using default value: {}", (Object)key, (Object)defaultValue);
        }
        return environment.getProperty(key, defaultValue);
    }

    private boolean propertyExists(Environment environment, String key) {
        return environment.getProperty(key) != null;
    }

    private String getRequiredProperty(Environment environment, String key) {
        if (!this.propertyExists(environment, key)) {
            throw new IllegalStateException(String.format("Required Encryption configuration property missing: %s", key));
        }
        return environment.getProperty(key);
    }
}

