/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot;

import com.ulisesbocchio.jasyptspringboot.EncryptableMapPropertySourceWrapper;
import com.ulisesbocchio.jasyptspringboot.StringEncryptorConfiguration;
import com.ulisesbocchio.jasyptspringboot.annotation.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.annotation.EncryptablePropertySources;
import java.io.FileNotFoundException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.stream.Stream;
import org.jasypt.encryption.StringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@Import(value={StringEncryptorConfiguration.class})
public class EncryptablePropertySourcesInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptablePropertySourcesInitializer.class);

    @Bean
    public static BeanFactoryPostProcessor encrytablePropertySourceAnnotationPostProcessor() {
        return new EncryptablePropertySourceAnnotationBeanFactoryPostProcessor();
    }

    private static class EncryptablePropertySourceAnnotationBeanFactoryPostProcessor
    implements BeanFactoryPostProcessor {
        private EncryptablePropertySourceAnnotationBeanFactoryPostProcessor() {
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            ConfigurableEnvironment env = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
            StaticApplicationContext ac = new StaticApplicationContext();
            StringEncryptor encryptor = (StringEncryptor)beanFactory.getBean(StringEncryptor.class);
            MutablePropertySources propertySources = env.getPropertySources();
            Stream<AnnotationAttributes> encryptablePropertiesMetadata = EncryptablePropertySourceAnnotationBeanFactoryPostProcessor.getEncryptablePropertiesMetadata(beanFactory);
            encryptablePropertiesMetadata.forEach(arg_0 -> EncryptablePropertySourceAnnotationBeanFactoryPostProcessor.lambda$postProcessBeanFactory$3(env, (ApplicationContext)ac, encryptor, propertySources, arg_0));
        }

        private static void loadEncryptablePropertySource(AnnotationAttributes encryptablePropertySource, ConfigurableEnvironment env, ApplicationContext ac, StringEncryptor encryptor, MutablePropertySources propertySources) throws BeansException {
            try {
                PropertySource ps = EncryptablePropertySourceAnnotationBeanFactoryPostProcessor.createPropertySource(encryptablePropertySource, env, (ResourceLoader)ac, encryptor);
                if (ps != null) {
                    propertySources.addLast(ps);
                }
            }
            catch (Exception e) {
                throw new ApplicationContextException("Exception Creating PropertySource", (Throwable)e);
            }
        }

        private static PropertySource createPropertySource(AnnotationAttributes propertySource, ConfigurableEnvironment environment, ResourceLoader resourceLoader, StringEncryptor encryptor) throws Exception {
            Object rps = null;
            String name = propertySource.getString("name");
            String[] locations = propertySource.getStringArray("value");
            boolean ignoreResourceNotFound = propertySource.getBoolean("ignoreResourceNotFound");
            Assert.isTrue((locations.length > 0 ? 1 : 0) != 0, (String)"At least one @PropertySource(value) location is required");
            for (String location : locations) {
                try {
                    String resolvedLocation = environment.resolveRequiredPlaceholders(location);
                    Resource resource = resourceLoader.getResource(resolvedLocation);
                    rps = StringUtils.hasText((String)name) ? new ResourcePropertySource(name, resource) : new ResourcePropertySource(resource);
                    rps = new EncryptableMapPropertySourceWrapper((MapPropertySource)rps, encryptor);
                }
                catch (FileNotFoundException | IllegalArgumentException ex) {
                    if (ignoreResourceNotFound) continue;
                    throw ex;
                }
            }
            return rps;
        }

        private static Stream<AnnotationAttributes> getEncryptablePropertiesMetadata(ConfigurableListableBeanFactory beanFactory) {
            Stream<AnnotationAttributes> source = EncryptablePropertySourceAnnotationBeanFactoryPostProcessor.getBeanDefinitionsForAnnotation(beanFactory, EncryptablePropertySource.class);
            Stream sources = EncryptablePropertySourceAnnotationBeanFactoryPostProcessor.getBeanDefinitionsForAnnotation(beanFactory, EncryptablePropertySources.class).flatMap(map -> Arrays.stream((AnnotationAttributes[])map.get((Object)"value")));
            return Stream.concat(source, sources);
        }

        private static Stream<AnnotationAttributes> getBeanDefinitionsForAnnotation(ConfigurableListableBeanFactory bf, Class<? extends Annotation> annotation) {
            return Arrays.stream(bf.getBeanNamesForAnnotation(annotation)).map(arg_0 -> ((ConfigurableListableBeanFactory)bf).getBeanDefinition(arg_0)).filter(bd -> bd instanceof AnnotatedGenericBeanDefinition).map(bd -> (AnnotatedGenericBeanDefinition)bd).map(AnnotatedGenericBeanDefinition::getMetadata).filter(md -> md.hasAnnotation(annotation.getName())).map(md -> (AnnotationAttributes)md.getAnnotationAttributes(annotation.getName()));
        }

        private static /* synthetic */ void lambda$postProcessBeanFactory$3(ConfigurableEnvironment configurableEnvironment, ApplicationContext applicationContext, StringEncryptor stringEncryptor, MutablePropertySources mutablePropertySources, AnnotationAttributes eps) {
            EncryptablePropertySourceAnnotationBeanFactoryPostProcessor.loadEncryptablePropertySource(eps, configurableEnvironment, applicationContext, stringEncryptor, mutablePropertySources);
        }
    }
}

