/*
 * Decompiled with CFR 0.152.
 */
package com.tylersuehr.esr.extras;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import com.tylersuehr.esr.extras.AbstractContentLoadingState;

class CardContentLoadingState
extends AbstractContentLoadingState {
    private final int large;
    private int circleSize;
    private int lineHeight;

    CardContentLoadingState(Context c) {
        super(c);
        this.setNumberOfContentItems(2);
        DisplayMetrics dm = c.getResources().getDisplayMetrics();
        this.large = (int)(16.0f * dm.density);
        this.circleSize = (int)(40.0f * dm.density);
        this.lineHeight = (int)(12.0f * dm.density);
    }

    @Override
    protected void onSetupContentPaint(@NonNull Context c, @NonNull Paint contentPaint) {
        contentPaint.setColor(-7829368);
    }

    @Override
    protected void renderContent(int numberOfContentItems, int availableWidth, int availableHeight, Canvas canvas, Paint contentPaint) {
        int radius = this.circleSize >> 1;
        int verticalDistance = this.sizeOfContentItem();
        float dx = 0.0f;
        float dy = 0.0f;
        for (int i = 0; i < numberOfContentItems; ++i) {
            dx = radius + this.large;
            dy = i * verticalDistance + radius + this.large;
            canvas.drawCircle(dx, dy, (float)radius, contentPaint);
            int offset = this.circleSize - this.lineHeight >> 1;
            canvas.drawRect(dx += (float)(radius + this.large), dy -= (float)(radius - offset), dx + (float)radius + (float)(availableWidth >> 2), dy + (float)this.lineHeight, contentPaint);
            int longLineDistance = this.lineHeight + this.large;
            for (int j = 0; j < 4; ++j) {
                dx = this.large;
                dy = j * longLineDistance + (i * verticalDistance + this.circleSize + (this.large << 1));
                canvas.drawRect(dx, dy, dx + (float)(availableWidth - (this.large << (j == 3 ? 3 : 1))), dy + (float)this.lineHeight, contentPaint);
            }
        }
    }

    @Override
    protected int sizeOfContentItem() {
        return this.circleSize + 6 * this.large + 4 * this.lineHeight;
    }
}

