/*
 * Decompiled with CFR 0.152.
 */
package com.tylersuehr.esr;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.View;
import com.tylersuehr.esr.AbstractStateDisplay;
import com.tylersuehr.esr.EmptyStateRecyclerView;

public class TextStateDisplay
extends AbstractStateDisplay {
    private boolean textLayoutsConfigured = false;
    private final TextPaint titlePaint = new TextPaint(1);
    private StaticLayout titleLayout;
    private String title;
    private final TextPaint subtitlePaint = new TextPaint(1);
    private StaticLayout subtitleLayout;
    private String subtitle;
    private int textGravity = 17;
    private int titleSpacing;

    public TextStateDisplay(Context c) {
        this(c, "", "");
    }

    public TextStateDisplay(Context c, @NonNull String title, @Nullable String subtitle) {
        DisplayMetrics dm = c.getResources().getDisplayMetrics();
        int large = (int)(16.0f * dm.density);
        this.setPadding(large, large, large, large);
        this.titleSpacing = (int)(4.0f * dm.scaledDensity);
        this.titlePaint.setTextAlign(Paint.Align.CENTER);
        this.titlePaint.setTextSize(18.0f * dm.scaledDensity);
        this.titlePaint.setColor(-16777216);
        this.title = title;
        this.titleLayout = new StaticLayout((CharSequence)title, this.titlePaint, (int)this.titlePaint.measureText(title), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        this.subtitlePaint.setTextSize(14.0f * dm.scaledDensity);
        this.subtitlePaint.setTextAlign(Paint.Align.CENTER);
        this.subtitlePaint.setColor(-7829368);
        this.subtitle = subtitle;
        this.subtitleLayout = new StaticLayout((CharSequence)subtitle, this.subtitlePaint, (int)this.subtitlePaint.measureText(subtitle), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
    }

    @Override
    public void onDrawState(EmptyStateRecyclerView rv, Canvas canvas) {
        int width = rv.getMeasuredWidth();
        int height = rv.getMeasuredHeight();
        this.configureTextLayouts(width);
        int verticalGravity = this.textGravity & 0x70;
        switch (verticalGravity) {
            case 16: {
                float dy = (height >> 1) - ((int)this.getFullTextHeight() >> 1);
                break;
            }
            case 80: {
                float dy = (float)height - this.getFullTextHeight();
                break;
            }
            default: {
                float dy = 0.0f;
            }
        }
        int horizontalGravity = Gravity.getAbsoluteGravity((int)this.textGravity, (int)ViewCompat.getLayoutDirection((View)rv)) & 7;
        canvas.save();
        canvas.translate(this.getDx(width, horizontalGravity, (Paint)this.titlePaint, this.titleLayout), dy += (float)this.getPaddingTop());
        this.titleLayout.draw(canvas);
        canvas.restore();
        canvas.save();
        canvas.translate(this.getDx(width, horizontalGravity, (Paint)this.subtitlePaint, this.subtitleLayout), dy += (float)(this.titleLayout.getHeight() + this.titleSpacing));
        this.subtitleLayout.draw(canvas);
        canvas.restore();
    }

    @Override
    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.invalidateText();
    }

    public void setTextGravity(int gravity) {
        int horizontalGravity = Gravity.getAbsoluteGravity((int)gravity, (int)0) & 7;
        switch (horizontalGravity) {
            case 0x800003: {
                this.titlePaint.setTextAlign(Paint.Align.LEFT);
                this.subtitlePaint.setTextAlign(Paint.Align.LEFT);
                break;
            }
            case 1: {
                this.titlePaint.setTextAlign(Paint.Align.CENTER);
                this.subtitlePaint.setTextAlign(Paint.Align.CENTER);
            }
        }
        this.textGravity = gravity;
    }

    public void setTitleSpacing(int spacing) {
        this.titleSpacing = spacing;
    }

    public void setTitleTextColor(@ColorInt int color) {
        this.titlePaint.setColor(color);
        this.invalidateText();
    }

    public void setTitleTextSize(float textSize) {
        this.titlePaint.setTextSize(textSize);
        this.invalidateText();
    }

    public void setTitleTextAlign(Paint.Align align) {
        this.titlePaint.setTextAlign(align);
        this.invalidateText();
    }

    public void setTitle(String title) {
        this.title = title;
        this.invalidateText();
    }

    public void setSubtitleTextColor(@ColorInt int color) {
        this.subtitlePaint.setColor(color);
        this.invalidateText();
    }

    public void setSubtitleTextSize(float textSize) {
        this.subtitlePaint.setTextSize(textSize);
        this.invalidateText();
    }

    public void setSubtitleTextAlign(Paint.Align align) {
        this.subtitlePaint.setTextAlign(align);
        this.invalidateText();
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
        this.invalidateText();
    }

    public void setTypeface(Typeface typeface) {
        this.titlePaint.setTypeface(typeface);
        this.subtitlePaint.setTypeface(typeface);
        this.invalidateText();
    }

    private void invalidateText() {
        this.textLayoutsConfigured = false;
    }

    private float getFullTextHeight() {
        return this.titleLayout.getHeight() + this.subtitleLayout.getHeight() + this.titleSpacing + this.getPaddingTop() + this.getPaddingBottom();
    }

    private float getDx(int width, int horizontalGravity, Paint paint, StaticLayout layout) {
        float dx;
        boolean centered = paint.getTextAlign() == Paint.Align.CENTER;
        switch (horizontalGravity) {
            case 1: {
                dx = (width >> 1) - (centered ? 0 : (layout.getWidth() >> 1) - this.getPaddingLeft());
                break;
            }
            default: {
                dx = this.getPaddingLeft();
            }
        }
        return dx;
    }

    private void configureTextLayouts(int availableWidth) {
        if (!this.textLayoutsConfigured) {
            int totalNeededPadding = this.getPaddingLeft() + this.getPaddingRight();
            if (this.titleLayout.getWidth() + totalNeededPadding > availableWidth) {
                this.titleLayout = new StaticLayout((CharSequence)this.title, this.titlePaint, availableWidth, Layout.Alignment.ALIGN_NORMAL, 1.15f, 0.0f, false);
            }
            if (this.subtitleLayout.getWidth() + totalNeededPadding > availableWidth) {
                this.subtitleLayout = new StaticLayout((CharSequence)this.subtitle, this.subtitlePaint, availableWidth, Layout.Alignment.ALIGN_NORMAL, 1.15f, 0.0f, false);
            }
            this.textLayoutsConfigured = true;
        }
    }
}

