/*
 * Decompiled with CFR 0.152.
 */
package com.tylersuehr.esr;

import android.content.Context;
import android.graphics.Canvas;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.SparseArray;
import com.tylersuehr.esr.DefaultEmptyState;
import com.tylersuehr.esr.DefaultLoadingState;

public class EmptyStateRecyclerView
extends RecyclerView {
    public static final byte STATE_LOADING = 0;
    public static final byte STATE_EMPTY = 1;
    public static final byte STATE_ERROR = 2;
    public static final byte STATE_OK = 3;
    private byte state = (byte)3;
    @NonNull
    private SparseArray<StateDisplay> stateDisplays = new SparseArray();
    private OnStateChangedListener onStateChangedListener;

    public EmptyStateRecyclerView(Context context) {
        this(context, null);
    }

    public EmptyStateRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EmptyStateRecyclerView(Context c, @Nullable AttributeSet attrs, int defStyle) {
        super(c, attrs, defStyle);
        this.stateDisplays.put(0, (Object)new DefaultLoadingState(c, "Loading..."));
        this.stateDisplays.put(1, (Object)new DefaultEmptyState(c, "No Content", "AWWW...!"));
        this.stateDisplays.put(2, (Object)new DefaultEmptyState(c, "Something Went Wrong", "SORRY...!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchDraw(Canvas canvas) {
        StateDisplay display;
        super.dispatchDraw(canvas);
        EmptyStateRecyclerView emptyStateRecyclerView = this;
        synchronized (emptyStateRecyclerView) {
            display = (StateDisplay)this.stateDisplays.get((int)this.state);
        }
        if (display != null) {
            display.onDrawState(this, canvas);
        }
    }

    public void setStateDisplay(byte state, StateDisplay display) {
        if (display == null) {
            throw new NullPointerException("State display cannot be null!");
        }
        this.stateDisplays.put((int)state, (Object)display);
        this.requestLayout();
        this.invalidate();
    }

    public void setStateDisplays(byte[] states, StateDisplay[] displays) {
        if (states == null || displays == null) {
            throw new NullPointerException("States or displays cannot be null!");
        }
        if (states.length != displays.length) {
            throw new IllegalArgumentException("The amount of given states do not correspond to the amount of given displays!");
        }
        for (int i = 0; i < states.length; ++i) {
            this.stateDisplays.put((int)states[i], (Object)displays[i]);
        }
        this.requestLayout();
        this.invalidate();
    }

    public void removeStateDisplay(byte state) {
        int index = this.stateDisplays.indexOfKey((int)state);
        if (index > -1) {
            this.stateDisplays.removeAt(index);
            this.requestLayout();
            this.invalidate();
        }
    }

    public void clearStateDisplays() {
        if (this.stateDisplays.size() > 0) {
            this.stateDisplays.clear();
            this.requestLayout();
            this.invalidate();
        }
    }

    public void invokeState(byte state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        this.invalidate();
        if (this.onStateChangedListener != null) {
            this.onStateChangedListener.onStateChanged(state);
        }
    }

    public boolean isEmptyState() {
        return this.state == 1;
    }

    public boolean isErrorState() {
        return this.state == 2;
    }

    public boolean isLoadingState() {
        return this.state == 0;
    }

    public boolean isOkState() {
        return this.state == 3;
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.onStateChangedListener = listener;
    }

    public OnStateChangedListener getOnStateChangedListener() {
        return this.onStateChangedListener;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(byte var1);
    }

    public static interface StateDisplay {
        public void onDrawState(EmptyStateRecyclerView var1, Canvas var2);
    }
}

