/*
 * Decompiled with CFR 0.152.
 */
package com.tylersuehr.esr;

import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import com.tylersuehr.esr.EmptyStateRecyclerView;

public abstract class ContentItemLoadingStateFactory {
    private ContentItemLoadingStateFactory() {
    }

    public static AbstractContentItemLoadingState newListLoadingState(Context c) {
        return new ListContentLoadingState(c);
    }

    public static AbstractContentItemLoadingState newSingleListLoadingState(Context c) {
        return new SingleListContentLoadingState(c);
    }

    public static AbstractContentItemLoadingState newCardLoadingState(Context c) {
        return new CardContentLoadingState(c);
    }

    public static AbstractContentItemLoadingState newDocLoadingState(Context c) {
        return new DocContentLoadingState(c);
    }

    private static final class DocContentLoadingState
    extends AbstractContentItemLoadingState {
        private final int large;
        private int lineHeight;

        DocContentLoadingState(Context c) {
            super(c);
            DisplayMetrics dm = c.getResources().getDisplayMetrics();
            this.large = (int)(16.0f * dm.density);
            this.lineHeight = (int)(12.0f * dm.density);
        }

        @Override
        protected void onSetupContentPaint(@NonNull Context c, @NonNull Paint contentPaint) {
            contentPaint.setColor(-7829368);
        }

        @Override
        protected void renderContent(int numberOfContentItems, int availableWidth, int availableHeight, Canvas canvas, Paint contentPaint) {
            float dy = 0.0f;
            int lineWidth = availableWidth - this.large;
            int itemsToDraw = availableHeight / (this.lineHeight + this.large) / 2;
            for (int i = 0; i < itemsToDraw; ++i) {
                canvas.drawRect((float)this.large, dy += (float)this.large, (float)lineWidth, dy + (float)this.lineHeight, contentPaint);
                dy += (float)this.lineHeight;
            }
            canvas.drawRect((float)this.large, dy += (float)this.large, (float)(lineWidth - lineWidth / 4), dy + (float)this.lineHeight, contentPaint);
        }

        @Override
        protected int sizeOfContentItem() {
            return this.lineHeight;
        }
    }

    private static final class CardContentLoadingState
    extends AbstractContentItemLoadingState {
        private final int large;
        private int circleSize;
        private int lineHeight;

        CardContentLoadingState(Context c) {
            super(c);
            this.setNumberOfContentItems(2);
            DisplayMetrics dm = c.getResources().getDisplayMetrics();
            this.large = (int)(16.0f * dm.density);
            this.circleSize = (int)(40.0f * dm.density);
            this.lineHeight = (int)(12.0f * dm.density);
        }

        @Override
        protected void onSetupContentPaint(@NonNull Context c, @NonNull Paint contentPaint) {
            contentPaint.setColor(-7829368);
        }

        @Override
        protected void renderContent(int numberOfContentItems, int availableWidth, int availableHeight, Canvas canvas, Paint contentPaint) {
            int radius = this.circleSize >> 1;
            int verticalDistance = this.sizeOfContentItem();
            float dx = 0.0f;
            float dy = 0.0f;
            for (int i = 0; i < numberOfContentItems; ++i) {
                dx = radius + this.large;
                dy = i * verticalDistance + radius + this.large;
                canvas.drawCircle(dx, dy, (float)radius, contentPaint);
                int offset = this.circleSize - this.lineHeight >> 1;
                canvas.drawRect(dx += (float)(radius + this.large), dy -= (float)(radius - offset), dx + (float)radius + (float)(availableWidth >> 2), dy + (float)this.lineHeight, contentPaint);
                int longLineDistance = this.lineHeight + this.large;
                for (int j = 0; j < 4; ++j) {
                    dx = this.large;
                    dy = j * longLineDistance + (i * verticalDistance + this.circleSize + (this.large << 1));
                    canvas.drawRect(dx, dy, dx + (float)(availableWidth - (this.large << (j == 3 ? 3 : 1))), dy + (float)this.lineHeight, contentPaint);
                }
            }
        }

        @Override
        protected int sizeOfContentItem() {
            return this.circleSize + 6 * this.large + 4 * this.lineHeight;
        }
    }

    private static final class SingleListContentLoadingState
    extends AbstractContentItemLoadingState {
        private final int large;
        private int circleSize;
        private int lineHeight;

        SingleListContentLoadingState(Context c) {
            super(c);
            DisplayMetrics dm = c.getResources().getDisplayMetrics();
            this.large = (int)(16.0f * dm.density);
            this.circleSize = (int)(40.0f * dm.density);
            this.lineHeight = (int)(12.0f * dm.density);
        }

        @Override
        protected void onSetupContentPaint(@NonNull Context c, @NonNull Paint contentPaint) {
            contentPaint.setColor(-7829368);
        }

        @Override
        protected void renderContent(int numberOfContentItems, int availableWidth, int availableHeight, Canvas canvas, Paint contentPaint) {
            int radius = this.circleSize >> 1;
            int verticalDistance = this.sizeOfContentItem();
            float dx = 0.0f;
            float dy = 0.0f;
            for (int i = 0; i < numberOfContentItems; ++i) {
                dx = radius + this.large;
                dy = i * verticalDistance + radius + this.large;
                canvas.drawCircle(dx, dy, (float)radius, contentPaint);
                int diff = this.circleSize - this.lineHeight >> 1;
                canvas.drawRect(dx += (float)(radius + this.large), dy -= (float)(radius - diff), dx + ((float)availableWidth - dx - (float)(this.large << 1)), dy + (float)this.lineHeight, contentPaint);
            }
        }

        @Override
        protected int sizeOfContentItem() {
            return this.circleSize + this.large;
        }
    }

    private static final class ListContentLoadingState
    extends AbstractContentItemLoadingState {
        private final int small;
        private final int large;
        private int circleSize;
        private int lineHeight;

        ListContentLoadingState(Context c) {
            super(c);
            DisplayMetrics dm = c.getResources().getDisplayMetrics();
            this.small = (int)(8.0f * dm.density);
            this.large = (int)(16.0f * dm.density);
            this.circleSize = (int)(40.0f * dm.density);
            this.lineHeight = (int)(12.0f * dm.density);
        }

        @Override
        protected void onSetupContentPaint(@NonNull Context c, @NonNull Paint contentPaint) {
            contentPaint.setColor(-7829368);
        }

        @Override
        protected void renderContent(int numberOfContentItems, int availableWidth, int availableHeight, Canvas canvas, Paint contentPaint) {
            int radius = this.circleSize >> 1;
            int verticalDistance = this.sizeOfContentItem();
            float dx = 0.0f;
            float dy = 0.0f;
            for (int i = 0; i < numberOfContentItems; ++i) {
                dx = radius + this.large;
                dy = i * verticalDistance + radius + this.large;
                canvas.drawCircle(dx, dy, (float)radius, contentPaint);
                int diff = this.circleSize - (this.lineHeight * 2 + this.small) >> 1;
                canvas.drawRect(dx += (float)(radius + this.large), dy -= (float)(radius - diff), dx + ((float)availableWidth - dx - (float)(this.large << 1)), dy + (float)this.lineHeight, contentPaint);
                canvas.drawRect(dx, dy += (float)(this.lineHeight + this.small), dx + ((float)availableWidth - dx - (float)(this.large << 3)), dy + (float)this.lineHeight, contentPaint);
            }
        }

        @Override
        protected int sizeOfContentItem() {
            return this.circleSize + this.large;
        }
    }

    public static abstract class AbstractContentItemLoadingState
    implements EmptyStateRecyclerView.StateDisplay {
        private static final int DEFAULT_ANIM_DURATION = 900;
        private final Paint contentPaint = new Paint(1);
        private boolean animateContentItems = true;
        private int numberOfContentItems = 3;
        private ValueAnimator anim;

        public AbstractContentItemLoadingState(Context c) {
            this.onSetupContentPaint(c, this.contentPaint);
        }

        @Override
        public final void onDrawState(final EmptyStateRecyclerView rv, Canvas canvas) {
            int width = rv.getMeasuredWidth();
            int height = rv.getMeasuredHeight();
            this.renderContent(this.numberOfContentItems, width, height, canvas, this.contentPaint);
            if (this.animateContentItems && this.anim == null) {
                this.anim = ObjectAnimator.ofObject((Object)this.contentPaint, (String)"color", (TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{Color.parseColor((String)"#E0E0E0"), Color.parseColor((String)"#BDBDBD"), Color.parseColor((String)"#9E9E9E")});
                this.onInterceptAnimatorCreation(this.anim);
                this.anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        rv.invalidate();
                    }
                });
                this.anim.start();
            }
        }

        protected void onInterceptAnimatorCreation(@NonNull ValueAnimator anim) {
            anim.setDuration(900L);
            anim.setRepeatMode(2);
            anim.setRepeatCount(-1);
        }

        protected abstract void onSetupContentPaint(@NonNull Context var1, @NonNull Paint var2);

        protected abstract void renderContent(int var1, int var2, int var3, Canvas var4, Paint var5);

        protected abstract int sizeOfContentItem();

        public void setAnimateContentItems(boolean animateContentItems) {
            this.animateContentItems = animateContentItems;
        }

        public void setNumberOfContentItems(int numberOfContentItems) {
            this.numberOfContentItems = numberOfContentItems;
        }
    }
}

