/*
 * Decompiled with CFR 0.152.
 */
package com.tylersuehr.bubbles;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import com.tylersuehr.bubbles.R;

public class CircleCountView
extends View {
    private final Paint circlePaint = new Paint(1);
    private final Paint textPaint = new Paint(1);
    private int borderWidth;
    private int borderColor;
    private int backColor;
    private int circleRadius;
    private int viewSize;
    private int textColor;
    private Typeface typeface;
    private CharSequence text;

    public CircleCountView(Context context) {
        this(context, null);
    }

    public CircleCountView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleCountView(Context c, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(c, attrs, defStyleAttr);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.CircleCountView);
        this.borderWidth = a.getDimensionPixelSize(R.styleable.CircleCountView_borderWidth, (int)(1.0f * dm.density));
        this.borderColor = a.getColor(R.styleable.CircleCountView_borderColor, ContextCompat.getColor((Context)c, (int)R.color.default_circle_border_color));
        this.backColor = a.getColor(R.styleable.CircleCountView_circleColor, ContextCompat.getColor((Context)c, (int)R.color.default_circle_back_color));
        this.textColor = a.getColor(R.styleable.CircleCountView_android_textColor, ContextCompat.getColor((Context)c, (int)R.color.default_circle_text_color));
        this.text = a.hasValue(R.styleable.CircleCountView_android_text) ? "+" + a.getString(R.styleable.CircleCountView_android_text) : "";
        a.recycle();
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.circlePaint.setColor(this.borderColor);
        this.textPaint.setColor(this.textColor);
        this.textPaint.setTypeface(this.typeface);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        float scaledDensity = dm.scaledDensity;
        float density = dm.density;
        if (widthMode == Integer.MIN_VALUE) {
            widthSize = (int)(40.0f * density);
        }
        int length = this.text.length();
        float textSize = (float)widthSize / density / (float)length * scaledDensity;
        this.textPaint.setTextSize(textSize);
        this.setMeasuredDimension(widthSize, widthSize);
    }

    protected void onDraw(Canvas canvas) {
        int viewWidth = this.getMeasuredWidth();
        int viewHeight = this.getMeasuredHeight();
        this.viewSize = Math.min(viewWidth, viewHeight);
        this.circleRadius = (this.viewSize - this.borderWidth * 2) / 2;
        if (this.viewSize == 0) {
            return;
        }
        if (this.viewSize / 3 < this.borderWidth) {
            this.borderWidth = this.viewSize / 3;
        }
        this.circlePaint.setColor(this.borderColor);
        int fullRadius = this.circleRadius + this.borderWidth;
        canvas.drawCircle((float)fullRadius, (float)fullRadius, (float)fullRadius, this.circlePaint);
        this.circlePaint.setColor(this.backColor);
        canvas.drawCircle((float)fullRadius, (float)fullRadius, (float)this.circleRadius, this.circlePaint);
        float textWidth = this.textPaint.measureText(this.text, 0, this.text.length());
        float dx = (viewWidth >> 1) - ((int)textWidth >> 1);
        float dy = (viewHeight >> 1) - ((int)(this.textPaint.descent() + this.textPaint.ascent()) >> 1) - 1;
        canvas.drawText(this.text, 0, this.text.length(), dx, dy, this.textPaint);
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        this.invalidate();
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        this.invalidate();
    }

    public int getBackColor() {
        return this.backColor;
    }

    public void setBackColor(int backColor) {
        this.backColor = backColor;
        this.invalidate();
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.textPaint.setColor(textColor);
        this.invalidate();
    }

    public Typeface getTypeface() {
        return this.typeface;
    }

    public void setTypeface(Typeface typeface) {
        this.typeface = typeface;
        this.textPaint.setTypeface(typeface);
        this.invalidate();
    }

    public CharSequence getText() {
        return this.text;
    }

    public void setText(CharSequence text) {
        this.text = text;
        this.invalidate();
    }

    public void setCount(int extraCount) {
        this.text = "+" + extraCount;
        this.requestLayout();
        this.invalidate();
    }
}

