/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart;

import com.twosigma.beakerx.chart.Color;
import com.twosigma.beakerx.chart.KeyboardCodes;
import com.twosigma.beakerx.chart.actions.GraphicsActionListener;
import com.twosigma.beakerx.chart.actions.GraphicsActionObject;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.widgets.CompiledCodeRunner;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class Graphics
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1878979081955090695L;
    private final String uid;
    private boolean visible = true;
    private String yAxisName = null;
    private GraphicsActionListener onClickListener;
    private String clickTag;
    private Map<String, GraphicsActionListener> onKeyListeners = new HashMap<String, GraphicsActionListener>();
    private Map<String, String> keyTags = new HashMap<String, String>();

    public Graphics() {
        this.uid = UUID.randomUUID().toString();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setYAxis(String yAxisName) {
        this.yAxisName = yAxisName;
    }

    public void setyAxis(String yAxisName) {
        this.yAxisName = yAxisName;
    }

    public String getYAxis() {
        return this.yAxisName;
    }

    public String getUid() {
        return this.uid;
    }

    public boolean hasClickAction() {
        return this.onClickListener != null || StringUtils.isNotEmpty((CharSequence)this.clickTag);
    }

    public String getClickTag() {
        return this.clickTag;
    }

    public Map<String, String> getKeyTags() {
        return this.keyTags;
    }

    public Object[] getKeys() {
        return this.onKeyListeners.keySet().toArray();
    }

    public Graphics onClick(GraphicsActionListener onClickListener) {
        this.onClickListener = onClickListener;
        return this;
    }

    public Graphics onClick(String tag) {
        this.clickTag = tag;
        return this;
    }

    public void fireClick(GraphicsActionObject actionObject, Message message) {
        if (this.onClickListener != null) {
            CompiledCodeRunner.runCompiledCode(message, params -> {
                GraphicsActionObject ao = (GraphicsActionObject)params[0];
                ao.setGraphics(this);
                this.onClickListener.execute(ao);
                return MIMEContainer.HIDDEN;
            }, actionObject);
        }
    }

    public Graphics onKey(String key, GraphicsActionListener listener) {
        this.onKeyListeners.put(key, listener);
        return this;
    }

    public Graphics onKey(KeyboardCodes key, GraphicsActionListener listener) {
        this.onKeyListeners.put(key.name(), listener);
        return this;
    }

    public Graphics onKey(String key, String tag) {
        this.keyTags.put(key, tag);
        return this;
    }

    public Graphics onKey(KeyboardCodes key, String tag) {
        this.keyTags.put(key.name(), tag);
        return this;
    }

    public void fireOnKey(String key, GraphicsActionObject actionObject, Message message) {
        GraphicsActionListener listener = this.onKeyListeners.get(key);
        if (listener != null) {
            CompiledCodeRunner.runCompiledCode(message, params -> {
                GraphicsActionListener listener1 = (GraphicsActionListener)params[0];
                GraphicsActionObject ao = (GraphicsActionObject)params[1];
                ao.setGraphics(this);
                listener1.execute(ao);
                return MIMEContainer.HIDDEN;
            }, listener, actionObject);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return SerializationUtils.clone((Serializable)this);
    }

    public abstract void setColori(Color var1);

    public abstract Color getColor();
}

