/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.services;

import android.app.PendingIntent;
import android.content.Context;
import androidx.core.app.NotificationManagerCompat;
import com.huawei.hms.push.HmsMessageService;
import com.huawei.hms.push.RemoteMessage;
import com.twincoders.twinpush.sdk.TwinPushSDK;
import com.twincoders.twinpush.sdk.logging.Ln;
import com.twincoders.twinpush.sdk.notifications.PushNotification;
import com.twincoders.twinpush.sdk.services.DefaultNotificationService;
import com.twincoders.twinpush.sdk.services.PushReceiverService;
import java.util.Map;

public class TpHmsMessageService
extends HmsMessageService
implements PushReceiverService {
    protected final DefaultNotificationService defaultService = new DefaultNotificationService();

    public void onMessageReceived(RemoteMessage message) {
        Ln.i("Received message", new Object[0]);
        if (message.getDataOfMap().containsKey("message")) {
            TwinPushSDK twinpush = TwinPushSDK.getInstance((Context)this);
            twinpush.createNotificationChannel();
            PushNotification notification = this.getNotification(message.getDataOfMap());
            if (twinpush.isPushAckEnabled() && NotificationManagerCompat.from((Context)this.getBaseContext()).areNotificationsEnabled()) {
                twinpush.onNotificationReceived(notification);
            }
            this.displayNotification(this.getBaseContext(), notification);
        } else {
            Ln.i("Attribute 'message' not found in payload, calling parent method", new Object[0]);
            super.onMessageReceived(message);
        }
    }

    public void onNewToken(String s) {
        super.onNewToken(s);
        Ln.d("TwinPush Huawei HMS on new token called", new Object[0]);
        TwinPushSDK twinPush = TwinPushSDK.getInstance(this.getApplicationContext());
        Ln.d("Huawei HMS Token created: " + s, new Object[0]);
        if (twinPush.isDeviceRegistered()) {
            twinPush.register();
        }
    }

    public void onTokenError(Exception e) {
        Ln.e(e, (Object)"Error obtaining Huawei Push Token", new Object[0]);
        super.onTokenError(e);
    }

    @Override
    public void displayNotification(Context context, PushNotification notification) {
        this.defaultService.displayNotification(context, notification, this.getContentIntent(context, notification));
    }

    @Override
    public PendingIntent getContentIntent(Context context, PushNotification notification) {
        return this.defaultService.getContentIntent(context, notification);
    }

    @Override
    public PushNotification getNotification(Map<String, String> data) {
        return this.defaultService.getNotification(data);
    }

    @Override
    public void onSilentPushReceived(Context context, PushNotification notification) {
        this.defaultService.onSilentPushReceived(context, notification);
    }
}

