/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.services;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.twincoders.twinpush.sdk.entities.RegistrationInfo;
import com.twincoders.twinpush.sdk.logging.Ln;
import com.twincoders.twinpush.sdk.logging.Strings;
import java.io.Serializable;

public abstract class RegistrationIntentReceiver
extends BroadcastReceiver {
    private static final String REGISTER_REQUEST_INTENT = "com.twinpush.ON_REGISTER_REQUEST";
    private static final String REGISTER_INFO_EXTRA = "REGISTER_INFO_EXTRA";

    public void onReceive(Context context, Intent intent) {
        if (Strings.equals(intent.getAction(), REGISTER_REQUEST_INTENT)) {
            Ln.d("Registration intent received", new Object[0]);
            RegistrationInfo info = this.getRegistrationInfoFromIntent(intent);
            if (info != null) {
                this.onRegistrationIntent(context, info);
            } else {
                Ln.e("Can not proceed with external registration: registration info is null", new Object[0]);
            }
        } else {
            Ln.w("Received intent with unknown action: %s", intent.getAction());
        }
    }

    public abstract void onRegistrationIntent(Context var1, RegistrationInfo var2);

    private RegistrationInfo getRegistrationInfoFromIntent(@NonNull Intent intent) {
        RegistrationInfo info = null;
        if (intent.hasExtra(REGISTER_INFO_EXTRA)) {
            try {
                info = (RegistrationInfo)intent.getSerializableExtra(REGISTER_INFO_EXTRA);
            }
            catch (Exception ex) {
                Ln.e(ex, (Object)"Error when trying to obtain registration info from intent", new Object[0]);
            }
        }
        return info;
    }

    public static void launchExternalRegistrationIntent(@NonNull Context context, @NonNull RegistrationInfo info) {
        Ln.d("Starting intent with ACTION '%s'", REGISTER_REQUEST_INTENT);
        Intent registrationIntent = new Intent(REGISTER_REQUEST_INTENT);
        registrationIntent.putExtra(REGISTER_INFO_EXTRA, (Serializable)info);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(registrationIntent);
    }

    public void registerReceiver(Context context) {
        LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)this, new IntentFilter(REGISTER_REQUEST_INTENT));
    }

    public void unregisterReceiver(Context context) {
        LocalBroadcastManager.getInstance((Context)context).unregisterReceiver((BroadcastReceiver)this);
    }
}

