/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.services;

import android.app.PendingIntent;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.core.app.NotificationManagerCompat;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.twincoders.twinpush.sdk.TwinPushSDK;
import com.twincoders.twinpush.sdk.logging.Ln;
import com.twincoders.twinpush.sdk.notifications.PushNotification;
import com.twincoders.twinpush.sdk.services.DefaultNotificationService;
import com.twincoders.twinpush.sdk.services.PushReceiverService;
import java.util.Map;

public class NotificationIntentService
extends FirebaseMessagingService
implements PushReceiverService {
    public static final String ON_NOTIFICATION_OPENED_ACTION = "con.twincoders.twinpush.sdk.PUSH_NOTIFICATION_OPENED";
    public static final String EXTRA_NOTIFICATION = "notification";
    public static final String PROPERTY_CHANNEL_ID = "tp_channel_id";
    protected final DefaultNotificationService defaultService = new DefaultNotificationService();

    public void onMessageReceived(RemoteMessage message) {
        Ln.i("Received message", new Object[0]);
        if (message.getNotification() != null) {
            super.onMessageReceived(message);
        } else {
            TwinPushSDK twinpush = TwinPushSDK.getInstance((Context)this);
            twinpush.createNotificationChannel();
            PushNotification notification = this.getNotification(message.getData());
            if (twinpush.isPushAckEnabled() && NotificationManagerCompat.from((Context)this.getBaseContext()).areNotificationsEnabled()) {
                twinpush.onNotificationReceived(notification);
            }
            if (notification.isSilent()) {
                this.onSilentPushReceived(this.getBaseContext(), notification);
            } else {
                this.displayNotification(this.getBaseContext(), notification);
            }
        }
    }

    public void onNewToken(@NonNull String s) {
        super.onNewToken(s);
        Ln.d("TwinPush on new token called", new Object[0]);
        TwinPushSDK twinPush = TwinPushSDK.getInstance(this.getApplicationContext());
        Ln.d("FCM Token created: " + s, new Object[0]);
        if (twinPush.isDeviceRegistered()) {
            twinPush.register();
        }
    }

    @Override
    public void displayNotification(Context context, PushNotification notification) {
        this.defaultService.displayNotification(context, notification, this.getContentIntent(context, notification));
    }

    @Override
    public PendingIntent getContentIntent(Context context, PushNotification notification) {
        return this.defaultService.getContentIntent(context, notification);
    }

    @Override
    public PushNotification getNotification(Map<String, String> data) {
        return this.defaultService.getNotification(data);
    }

    @Override
    public void onSilentPushReceived(Context context, PushNotification notification) {
        this.defaultService.onSilentPushReceived(context, notification);
    }
}

