/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.entities;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.NonNull;
import com.twincoders.twinpush.sdk.TwinPushSDK;
import com.twincoders.twinpush.sdk.entities.Platform;
import com.twincoders.twinpush.sdk.logging.Ln;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class RegistrationInfo
implements Serializable {
    private Platform platform = Platform.ANDROID;
    private String sdkVersion = null;
    private String appVersion = null;
    private String osVersion = null;
    private Integer osVersionInt = null;
    private String language = null;
    private String deviceManufacturer = null;
    private String deviceModel = null;
    private String deviceCode = null;
    private String udid = null;
    private String deviceAlias = null;
    private String pushToken = null;
    private String appID = null;

    public static RegistrationInfo fromContext(Context context, @NonNull Platform platform, String udid, String deviceAlias, String pushToken) {
        RegistrationInfo info = new RegistrationInfo();
        try {
            info.appVersion = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Ln.e(e, (Object)"Could not obtain application version", new Object[0]);
        }
        info.sdkVersion = "3.7.1";
        info.platform = platform;
        info.udid = udid;
        info.deviceAlias = deviceAlias;
        info.pushToken = pushToken;
        info.osVersion = Build.VERSION.RELEASE;
        info.osVersionInt = Build.VERSION.SDK_INT;
        info.deviceManufacturer = RegistrationInfo.capitalize(Build.MANUFACTURER);
        info.deviceModel = RegistrationInfo.capitalize(Build.MODEL);
        info.deviceCode = RegistrationInfo.capitalize(Build.DEVICE);
        info.language = Locale.getDefault().toString();
        TwinPushSDK twinPush = TwinPushSDK.getInstance(context);
        info.appID = twinPush.getAppId();
        return info;
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first) || s.contains("_")) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }

    public void printLog() {
        Ln.d("============================================", new Object[0]);
        Ln.d("===      TwinPush Registration info      ===", new Object[0]);
        Ln.d("============================================", new Object[0]);
        Ln.d("TwinPush App ID: %s", this.appID);
        Ln.d("Platform:        %s", this.platform.getKey());
        Ln.d("App Version:     %s", this.appVersion);
        Ln.d("SDK Version:     %s", this.sdkVersion);
        Ln.d("Android Version: %s (API %d)", this.osVersion, this.osVersionInt);
        Ln.d("Device:          %s %s (%s)", this.deviceManufacturer, this.deviceModel, this.deviceCode);
        Ln.d("UDID:            %s", this.udid);
        Ln.d("Language:        %s", this.language);
        Ln.d("Alias:           %s", this.deviceAlias);
        Ln.d("Push Token:      %s", this.pushToken);
        Ln.d("============================================", new Object[0]);
    }

    private Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("app_id", this.appID);
        map.put("platform", this.platform.getKey());
        map.put("app_version", this.appVersion);
        map.put("sdk_version", this.sdkVersion);
        map.put("os_version", this.osVersion);
        map.put("os_version_api", this.osVersionInt);
        map.put("device_manufacturer", this.deviceManufacturer);
        map.put("device_model", this.deviceModel);
        map.put("device_code", this.deviceCode);
        map.put("udid", this.deviceCode);
        map.put("language", this.language);
        map.put("device_alias", this.deviceAlias);
        map.put("push_token", this.pushToken);
        return map;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.toMap().entrySet()) {
            builder.append(entry.getKey());
            builder.append("=");
            builder.append(entry.getValue());
            builder.append(";");
        }
        return builder.toString();
    }

    @NonNull
    public Platform getPlatform() {
        return this.platform;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public Integer getOsVersionInt() {
        return this.osVersionInt;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getDeviceManufacturer() {
        return this.deviceManufacturer;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public String getUdid() {
        return this.udid;
    }

    public String getDeviceAlias() {
        return this.deviceAlias;
    }

    public String getPushToken() {
        return this.pushToken;
    }
}

