/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.controllers;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.twincoders.twinpush.sdk.TwinPushSDK;
import com.twincoders.twinpush.sdk.controllers.LegacyNotificationItemView;
import com.twincoders.twinpush.sdk.notifications.PushNotification;
import java.util.List;

public abstract class LegacyNotificationAdapter
extends BaseAdapter
implements LegacyNotificationItemView.Listener {
    List<PushNotification> notifications;
    Listener listener;
    Context context;

    public LegacyNotificationAdapter(Context context) {
        this.context = context;
    }

    public int getCount() {
        int count = 0;
        if (this.notifications != null) {
            count = this.notifications.size();
        }
        return count;
    }

    public PushNotification getItem(int position) {
        PushNotification n = null;
        if (position < this.notifications.size()) {
            n = this.notifications.get(position);
        }
        return n;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        LegacyNotificationItemView view = null;
        LegacyNotificationItemView reuseView = convertView instanceof LegacyNotificationItemView ? (LegacyNotificationItemView)convertView : null;
        view = convertView != null && reuseView != null ? reuseView : this.getViewInstance(this.context);
        if (view != null) {
            PushNotification notification = this.getItem(position);
            view.setNotification(notification);
            view.setListener(this);
        }
        return (View)view;
    }

    public abstract LegacyNotificationItemView getViewInstance(Context var1);

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setNotifications(List<PushNotification> notifications) {
        this.notifications = notifications;
    }

    public List<PushNotification> getNotifications() {
        return this.notifications;
    }

    @Override
    public void onNotificationSelected(PushNotification notification) {
        if (this.listener != null) {
            TwinPushSDK.getInstance(this.context).onNotificationOpen(notification);
            this.listener.onNotificationSelected(notification);
        }
    }

    @Override
    public void onNotificationLongClicked(PushNotification notification) {
        if (this.listener != null) {
            this.listener.onNotificationLongClicked(notification);
        }
    }

    public static interface Listener {
        public void onNotificationSelected(PushNotification var1);

        public void onNotificationLongClicked(PushNotification var1);
    }
}

