/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.communications.requests.register;

import com.twincoders.twinpush.sdk.communications.TwinRequest;
import com.twincoders.twinpush.sdk.communications.requests.TwinPushRequest;
import com.twincoders.twinpush.sdk.logging.Ln;
import org.json.JSONException;
import org.json.JSONObject;

public class GetBadgeCountRequest
extends TwinPushRequest {
    private static final String[] SEGMENTS = new String[]{"badge"};
    private static final String BADGE_COUNT_KEY = "badge";
    private Listener listener;

    public GetBadgeCountRequest(String applicationId, String deviceId, Listener listener) {
        super(applicationId, deviceId);
        this.listener = listener;
        this.httpMethod = TwinRequest.HttpMethod.GET;
        for (String segment : SEGMENTS) {
            this.addSegmentParam(segment);
        }
    }

    @Override
    protected void onSuccess(JSONObject response) {
        try {
            int badgeCount = response.getInt(BADGE_COUNT_KEY);
            this.getListener().onSuccess(badgeCount);
        }
        catch (JSONException e) {
            Ln.e(e, (Object)"Error while trying to parse badge count from response", new Object[0]);
            this.getListener().onError((Exception)((Object)e));
        }
    }

    @Override
    public Listener getListener() {
        return this.listener;
    }

    public static interface Listener
    extends TwinRequest.ErrorListener {
        public void onSuccess(int var1);
    }
}

