/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.communications.requests.notifications;

import com.twincoders.twinpush.sdk.communications.DefaultRequestParam;
import com.twincoders.twinpush.sdk.communications.TwinRequest;
import com.twincoders.twinpush.sdk.communications.requests.TwinPushRequest;
import com.twincoders.twinpush.sdk.logging.Ln;
import com.twincoders.twinpush.sdk.notifications.PushNotification;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetNotificationsRequest
extends TwinPushRequest {
    private static final String SEARCH_SEGMENT = "search_notifications";
    private static final String PAGE_KEY = "page";
    private static final String RESULTS_PER_PAGE_KEY = "per_page";
    private static final String TAGS_KEY = "tags";
    private static final String NO_TAGS_KEY = "no_tags";
    private static final String RICH_NOTIFICATION_TAG = "tp_rich";
    private static final String RESPONSE_TOTAL_PAGES_KEY = "total_pages";
    private static final String RESPONSE_NOTIF_ARRAY_KEY = "objects";
    Listener listener;

    public GetNotificationsRequest(String applicationId, String deviceId, int page, int resultsPerPage, List<String> tags, List<String> noTags, boolean ignoreNonRichNotifications, Listener listener) {
        super(applicationId, deviceId);
        this.listener = listener;
        this.httpMethod = TwinRequest.HttpMethod.POST;
        this.addSegmentParam(SEARCH_SEGMENT);
        this.addParam(PAGE_KEY, String.valueOf(page + 1));
        this.addParam(RESULTS_PER_PAGE_KEY, String.valueOf(resultsPerPage));
        if (ignoreNonRichNotifications) {
            if (tags == null) {
                tags = new ArrayList<String>();
            }
            tags.add(RICH_NOTIFICATION_TAG);
        }
        this.addParam(DefaultRequestParam.arrayParam(TAGS_KEY, tags));
        this.addParam(DefaultRequestParam.arrayParam(NO_TAGS_KEY, noTags));
    }

    @Override
    protected void onSuccess(JSONObject response) {
        int totalPages = 0;
        ArrayList<PushNotification> notifications = new ArrayList<PushNotification>();
        try {
            if (response.has(RESPONSE_TOTAL_PAGES_KEY)) {
                totalPages = response.getInt(RESPONSE_TOTAL_PAGES_KEY);
            }
            JSONArray notifJsonArray = response.getJSONArray(RESPONSE_NOTIF_ARRAY_KEY);
            for (int i = 0; i < notifJsonArray.length(); ++i) {
                JSONObject json = notifJsonArray.getJSONObject(i);
                PushNotification n = this.parseNotification(json);
                notifications.add(n);
            }
            this.getListener().onSuccess(notifications, totalPages);
        }
        catch (JSONException e) {
            Ln.e(e, (Object)"Error while trying to parse notifications from response", new Object[0]);
            this.getListener().onError((Exception)((Object)e));
        }
    }

    @Override
    public Listener getListener() {
        return this.listener;
    }

    public static interface Listener
    extends TwinRequest.ErrorListener {
        public void onSuccess(List<PushNotification> var1, int var2);
    }
}

