/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.communications.requests.notifications;

import com.twincoders.twinpush.sdk.communications.TwinRequest;
import com.twincoders.twinpush.sdk.communications.requests.TwinPushRequest;
import com.twincoders.twinpush.sdk.entities.InboxSummary;
import com.twincoders.twinpush.sdk.logging.Ln;
import org.json.JSONException;
import org.json.JSONObject;

public class GetInboxSummaryRequest
extends TwinPushRequest {
    private static final String[] SEGMENTS = new String[]{"inbox_summary"};
    private static final String TOTAL_COUNT_KEY = "total_count";
    private static final String UNOPENED_COUNT_KEY = "unopened_count";
    private Listener listener;

    public GetInboxSummaryRequest(String applicationId, String deviceId, Listener listener) {
        super(applicationId, deviceId);
        this.listener = listener;
        this.httpMethod = TwinRequest.HttpMethod.GET;
        for (String segment : SEGMENTS) {
            this.addSegmentParam(segment);
        }
    }

    @Override
    protected void onSuccess(JSONObject response) {
        try {
            InboxSummary summary = new InboxSummary();
            summary.setTotalCount(response.getInt(TOTAL_COUNT_KEY));
            summary.setUnopenedCount(response.getInt(UNOPENED_COUNT_KEY));
            this.getListener().onSuccess(summary);
        }
        catch (JSONException e) {
            Ln.e(e, (Object)"Error while trying to parse inbox summary from response", new Object[0]);
            this.getListener().onError((Exception)((Object)e));
        }
    }

    @Override
    public Listener getListener() {
        return this.listener;
    }

    public static interface Listener
    extends TwinRequest.ErrorListener {
        public void onSuccess(InboxSummary var1);
    }
}

