/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.communications;

import androidx.annotation.Nullable;
import com.android.volley.NetworkResponse;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.twincoders.twinpush.sdk.logging.Ln;
import java.util.Map;
import org.json.JSONObject;

public class TwinPushException
extends Exception {
    private int statusCode = 500;
    private String errorType = null;
    private String errorMessage = null;
    private VolleyError error;

    TwinPushException(VolleyError error) {
        super((Throwable)error);
        this.error = error;
        NetworkResponse response = error.networkResponse;
        if (response != null) {
            try {
                String jsonString = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers, (String)"UTF-8"));
                JSONObject json = new JSONObject(jsonString);
                JSONObject errorInfo = json.getJSONObject("errors");
                this.errorType = errorInfo.getString("type");
                this.errorMessage = errorInfo.getString("message");
            }
            catch (Exception ex) {
                Ln.e(ex, (Object)"Could not obtain error details from body", new Object[0]);
            }
            NetworkResponse networkResponse = error.networkResponse;
            this.statusCode = networkResponse.statusCode;
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public VolleyError getError() {
        return this.error;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.errorMessage != null ? this.errorMessage : super.getMessage();
    }

    @Override
    @Nullable
    public String getLocalizedMessage() {
        return this.errorMessage != null ? this.errorMessage : super.getLocalizedMessage();
    }
}

