/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.communications;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.twincoders.twinpush.sdk.communications.RESTRequest;
import com.twincoders.twinpush.sdk.communications.TwinPushException;
import com.twincoders.twinpush.sdk.communications.TwinRequest;
import com.twincoders.twinpush.sdk.logging.Ln;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class RESTJSONRequest
extends RESTRequest {
    private static final String CONTENT_TYPE_VALUE = "application/json";
    private static final String EMPTY_RESPONSE = "{}";

    @Override
    public String getContentType() {
        return CONTENT_TYPE_VALUE;
    }

    @Override
    public void onResponseProcess(String response) {
        if (!this.isCanceled().booleanValue()) {
            try {
                JSONObject object = new JSONObject();
                if (response != null && response.trim().length() > 0) {
                    object = new JSONObject(response);
                }
                this.onResponseProcess(object);
            }
            catch (JSONException e) {
                Ln.e(e);
                this.onRequestError((Exception)((Object)e));
            }
            this.notifyFinishListeners();
        }
    }

    protected abstract void onResponseProcess(JSONObject var1);

    @Override
    public Request getRequest() {
        JSONObject js = null;
        Ln.i("Launching request: %s", this.getURL());
        if (this.getHttpMethod() == TwinRequest.HttpMethod.POST) {
            js = this.serializeBodyParams(this.getParams());
            Ln.i("INPUT: %s", js.toString());
        }
        return new JsonObjectRequest(this.getRequestMethod(), this.getURL(), js, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                Ln.i("OUTPUT: %s", response.length() > 0 ? response.toString() : "OK");
                RESTJSONRequest.this.onResponseProcess(response);
                RESTJSONRequest.this.notifyFinishListeners();
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Ln.i((Throwable)error, (Object)"ERROR %s", error.getMessage());
                RESTJSONRequest.this.onRequestError(new TwinPushException(error));
                RESTJSONRequest.this.notifyFinishListeners();
            }
        }){

            protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
                try {
                    if (response.data.length == 0) {
                        byte[] responseData = RESTJSONRequest.EMPTY_RESPONSE.getBytes("UTF-8");
                        response = new NetworkResponse(response.statusCode, responseData, response.notModified, response.networkTimeMs, response.allHeaders);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    Ln.e(e, (Object)"Error returning empty result", new Object[0]);
                }
                return super.parseNetworkResponse(response);
            }

            public Map<String, String> getHeaders() throws AuthFailureError {
                return RESTJSONRequest.this.getHeaders();
            }
        };
    }

    private int getRequestMethod() {
        switch (this.getHttpMethod()) {
            case GET: {
                return 0;
            }
            case DELETE: {
                return 3;
            }
            case POST: {
                return 1;
            }
        }
        return 0;
    }
}

