/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.communications;

import android.content.Context;
import android.os.Handler;
import androidx.annotation.NonNull;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;
import com.twincoders.twinpush.sdk.communications.TwinRequest;
import com.twincoders.twinpush.sdk.communications.TwinRequestLauncher;
import com.twincoders.twinpush.sdk.logging.Ln;
import java.util.HashMap;
import java.util.Map;

class DefaultRequestLauncher
implements TwinRequestLauncher {
    private Context context;
    private RequestQueue queue;
    private Map<TwinRequest, Request> activeRequests = new HashMap<TwinRequest, Request>();

    DefaultRequestLauncher(@NonNull Context context) {
        this.context = context;
        this.queue = Volley.newRequestQueue((Context)context);
    }

    @Override
    public void launchRequest(TwinRequest request) {
        Ln.v("Starting request: %s", request.getClass().getName());
        if (!this.activeRequests.containsKey(request)) {
            this.executeRequest(request);
        } else {
            Ln.w("Request already on queue. Ignoring...", new Object[0]);
        }
    }

    @Override
    public void cancelRequest(TwinRequest twinRequest) {
        if (this.activeRequests.containsKey(twinRequest)) {
            Request request = this.activeRequests.get(twinRequest);
            request.cancel();
            this.activeRequests.remove(twinRequest);
            Ln.v("Request canceled", new Object[0]);
        } else {
            Ln.v("Could not cancel request, not currently active", new Object[0]);
        }
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    private void executeRequest(final TwinRequest request) {
        Request volleyRequest = request.getRequest();
        this.activeRequests.put(request, volleyRequest);
        request.addOnRequestFinishListener(new TwinRequest.OnRequestFinishListener(){

            @Override
            public void onRequestFinish() {
                DefaultRequestLauncher.this.activeRequests.remove(request);
            }
        });
        if (!request.isDummy()) {
            this.queue.add(volleyRequest);
        } else {
            Handler handler = new Handler();
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!request.isCanceled().booleanValue()) {
                        DefaultRequestLauncher.this.requestEnded(request);
                        request.onResponseProcess("");
                    }
                }
            }, 1000L);
        }
    }

    private void requestEnded(TwinRequest request) {
        this.activeRequests.remove(request);
    }
}

