/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import androidx.annotation.NonNull;
import com.google.firebase.FirebaseApp;
import com.twincoders.twinpush.sdk.DefaultTwinPushSDK;
import com.twincoders.twinpush.sdk.communications.TwinRequest;
import com.twincoders.twinpush.sdk.communications.requests.notifications.GetInboxRequest;
import com.twincoders.twinpush.sdk.communications.requests.notifications.GetInboxSummaryRequest;
import com.twincoders.twinpush.sdk.communications.requests.notifications.GetNotificationDetailsRequest;
import com.twincoders.twinpush.sdk.communications.requests.notifications.GetNotificationsRequest;
import com.twincoders.twinpush.sdk.communications.requests.register.GetBadgeCountRequest;
import com.twincoders.twinpush.sdk.entities.InboxNotification;
import com.twincoders.twinpush.sdk.entities.LocationPrecision;
import com.twincoders.twinpush.sdk.entities.PropertyType;
import com.twincoders.twinpush.sdk.entities.RegistrationInfo;
import com.twincoders.twinpush.sdk.entities.TwinPushOptions;
import com.twincoders.twinpush.sdk.notifications.PushNotification;
import com.twincoders.twinpush.sdk.services.SilentPushReceiver;
import java.util.List;
import java.util.Map;

public abstract class TwinPushSDK {
    private static TwinPushSDK sharedInstance = null;

    public static TwinPushSDK getInstance(Context context) {
        if (sharedInstance == null) {
            sharedInstance = new DefaultTwinPushSDK(context);
        }
        return sharedInstance;
    }

    public abstract void setDeviceUDID(String var1);

    public abstract void register();

    public abstract void register(String var1);

    public abstract void register(String var1, OnRegistrationListener var2);

    public abstract void onRegistrationSuccess(@NonNull String var1, @NonNull RegistrationInfo var2);

    public abstract void unregister();

    public abstract void getNotifications(int var1, int var2, GetNotificationsRequest.Listener var3);

    public abstract void getNotifications(int var1, int var2, List<String> var3, List<String> var4, boolean var5, GetNotificationsRequest.Listener var6);

    public abstract void getUserInbox(int var1, int var2, GetInboxRequest.Listener var3);

    public abstract void getUserInbox(int var1, int var2, List<String> var3, List<String> var4, GetInboxRequest.Listener var5);

    public abstract void getUserInboxSummary(GetInboxSummaryRequest.Listener var1);

    public abstract void getNotification(String var1, GetNotificationDetailsRequest.Listener var2);

    public abstract void deleteNotification(InboxNotification var1, TwinRequest.DefaultListener var2);

    public abstract void setBadgeCount(int var1);

    public abstract void getBadgeCount(GetBadgeCountRequest.Listener var1);

    public abstract void setProperty(String var1, String var2);

    public abstract void setProperty(String var1, Boolean var2);

    public abstract void setProperty(String var1, Integer var2);

    public abstract void setProperty(String var1, Float var2);

    public abstract void setProperty(String var1, Double var2);

    public abstract void setEnumProperty(String var1, String var2);

    public abstract void setProperty(String var1, List<String> var2);

    public abstract void setProperty(String var1, Object var2, PropertyType var3, TwinRequest.DefaultListener var4);

    public abstract void clearProperties();

    public abstract void clearProperties(TwinRequest.DefaultListener var1);

    public abstract void startMonitoringLocationChanges();

    public abstract void startMonitoringLocationChanges(LocationPrecision var1);

    public abstract boolean isMonitoringLocationChanges();

    public abstract void stopMonitoringLocationChanges();

    public abstract void setLocation(double var1, double var3);

    public abstract void setLocation(Location var1);

    public abstract void updateLocation();

    public abstract void updateLocation(LocationPrecision var1);

    public abstract void activityStart(Activity var1);

    public abstract void activityStop(Activity var1);

    public abstract void onNotificationOpen(PushNotification var1);

    public abstract void onNotificationOpen(String var1);

    public abstract void onNotificationReceived(PushNotification var1);

    public abstract void onNotificationReceived(String var1);

    public abstract boolean setup(TwinPushOptions var1);

    public abstract void createNotificationChannel();

    public abstract String getDeviceAlias();

    public abstract String getDeviceId();

    public abstract String getApiKey();

    public abstract String getAppId();

    public abstract Location getLastKnownLocation();

    public abstract long getLocationMinUpdateTime();

    public abstract int getLocationMinUpdateDistance();

    public abstract boolean isDeviceRegistered();

    public abstract void setSSLPublicKeyCheck(String var1);

    public abstract String getSSLPublicKeyCheck();

    public abstract void addSSLIssuerCheck(String var1, String var2);

    public abstract void addSSLSubjectCheck(String var1, String var2);

    public abstract Map<String, String> getSSLIssuerChecks();

    public abstract Map<String, String> getSSLSubjectChecks();

    public abstract String getSubdomain();

    public abstract String getServerHost();

    public abstract SilentPushReceiver getSilentReceiver();

    public abstract FirebaseApp getFirebaseApp();

    public abstract void getFirebaseToken(@NonNull GetTokenListener var1);

    public abstract boolean isPushAckEnabled();

    public static interface GetTokenListener {
        public void onTokenError(Exception var1);

        public void onTokenSuccess(String var1);
    }

    public static interface OnRegistrationListener {
        public void onRegistrationError(Exception var1);

        public void onRegistrationSuccess(String var1);
    }
}

