/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.FirebaseMessaging;
import com.huawei.agconnect.AGConnectOptionsBuilder;
import com.huawei.hms.aaid.HmsInstanceId;
import com.huawei.hms.api.HuaweiMobileServicesUtil;
import com.huawei.hms.common.ApiException;
import com.securepreferences.SecurePreferences;
import com.twincoders.twinpush.sdk.R;
import com.twincoders.twinpush.sdk.TwinPushSDK;
import com.twincoders.twinpush.sdk.communications.TwinPushRequestFactory;
import com.twincoders.twinpush.sdk.communications.TwinRequest;
import com.twincoders.twinpush.sdk.communications.requests.TwinPushRequest;
import com.twincoders.twinpush.sdk.communications.requests.notifications.GetInboxRequest;
import com.twincoders.twinpush.sdk.communications.requests.notifications.GetInboxSummaryRequest;
import com.twincoders.twinpush.sdk.communications.requests.notifications.GetNotificationDetailsRequest;
import com.twincoders.twinpush.sdk.communications.requests.notifications.GetNotificationsRequest;
import com.twincoders.twinpush.sdk.communications.requests.register.GetBadgeCountRequest;
import com.twincoders.twinpush.sdk.communications.requests.register.RegisterRequest;
import com.twincoders.twinpush.sdk.entities.InboxNotification;
import com.twincoders.twinpush.sdk.entities.LocationPrecision;
import com.twincoders.twinpush.sdk.entities.Platform;
import com.twincoders.twinpush.sdk.entities.PropertyType;
import com.twincoders.twinpush.sdk.entities.RegistrationInfo;
import com.twincoders.twinpush.sdk.entities.RegistrationMode;
import com.twincoders.twinpush.sdk.entities.TwinPushOptions;
import com.twincoders.twinpush.sdk.logging.Ln;
import com.twincoders.twinpush.sdk.logging.Strings;
import com.twincoders.twinpush.sdk.notifications.PushNotification;
import com.twincoders.twinpush.sdk.services.LocationChangeReceiver;
import com.twincoders.twinpush.sdk.services.RegistrationIntentReceiver;
import com.twincoders.twinpush.sdk.services.SilentPushReceiver;
import com.twincoders.twinpush.sdk.util.LastLocationFinder;
import com.twincoders.twinpush.sdk.util.StringEncrypter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class DefaultTwinPushSDK
extends TwinPushSDK
implements LocationListener {
    private static final String PREF_FILE_NAME = "TwinPushPrefs";
    private static final String PREF_REGISTRATION_HASH = "REGISTRATION_HASH";
    private static final String PREF_REGISTRATION_MODE = "REGISTRATION_MODE";
    private static final String PREF_DEVICE_ID = "DEVICE_ID";
    private static final String PREF_DEVICE_UDID = "DEVICE_UDID";
    private static final String PREF_DEVICE_ALIAS = "DEVICE_ALIAS";
    private static final String PREF_TWINPUSH_API_KEY = "TWINPUSH_TOKEN";
    private static final String PREF_TWINPUSH_APP_ID = "TWINPUSH_APP_ID";
    private static final String PREF_TWINPUSH_SUBDOMAIN = "TWINPUSH_SUBDOMAIN";
    private static final String PREF_TWINPUSH_CUSTOM_HOST = "TWINPUSH_CUSTOM_HOST";
    private static final String PREF_PUSH_ACK_ENABLED = "PUSH_ACK_ENABLED";
    private static final String PREF_PREFERRED_PLATFORM = "PREFERRED_PLATFORM";
    private static final String PREF_SILENT_RECEIVER = "PREF_SILENT_RECEIVER";
    private static final String DEFAULT_SUBDOMAIN = "app";
    private static final String DEFAULT_HOST = "https://%s.twinpush.com";
    private static final String PREF_LOCATION_LATITUDE = "LOCATION_LATITUDE";
    private static final String PREF_LOCATION_LONGITUDE = "LOCATION_LONGITUDE";
    private static final String PREF_LOCATION_ALTITUDE = "LOCATION_ALTITUDE";
    private static final String PREF_LOCATION_PROVIDER = "LOCATION_PROVIDER";
    private static final String PREF_LOCATION_ACCURACY = "LOCATION_ACCURACY";
    private static final String PREF_LOCATION_TIME = "LOCATION_TIME";
    private static final String PREF_MONITOR_LOCATION_CHANGES = "MONITOR_LOCATION_CHANGES";
    private static final String PREF_LOCATION_MIN_UPDATE_TIME = "LOCATION_MIN_UPDATE_TIME";
    private static final String PREF_LOCATION_MIN_UPDATE_DISTANCE = "LOCATION_MIN_UPDATE_DISTANCE";
    private static final String PREF_SSL_PUBLIC_KEY = "PREF_SSL_PUBLIC_KEY";
    private static final String PREF_SSL_ISSUER = "PREF_SSL_ISSUER";
    private static final String PREF_SSL_SUBJECT = "PREF_SSL_SUBJECT";
    private final Context _context;
    private final List<Activity> openedActivities = new ArrayList<Activity>();
    private final LastLocationFinder locationFinder;
    private TwinPushRequest registerRequest = null;
    private TwinPushSDK.OnRegistrationListener registrationListener = null;
    private String deviceAlias = null;
    private String deviceId = null;
    private String apiKey = null;
    private String appId = null;
    private final Map<String, SharedPreferences> sharedPreferencesMap = new TreeMap<String, SharedPreferences>();
    private FirebaseApp firebase = null;
    private static final String FIREBASE_NAME = "twinpush";
    private static final String FIREBASE_DEFAULT_APP_NAME = "[DEFAULT]";

    DefaultTwinPushSDK(Context context) {
        this._context = context.getApplicationContext();
        this.locationFinder = new LastLocationFinder(context.getApplicationContext());
        this.locationFinder.setChangedLocationListener(this);
    }

    @Override
    public void register() {
        this.register(null);
    }

    @Override
    public void register(String deviceAlias) {
        this.register(deviceAlias, null);
    }

    @Override
    public void register(String deviceAlias, TwinPushSDK.OnRegistrationListener listener) {
        this.registrationListener = listener;
        AsyncTask.execute(() -> {
            String appId = this.getAppId();
            if (appId != null) {
                this.getPlatformAndToken((platform, pushToken) -> {
                    String newDeviceAlias = deviceAlias != null ? deviceAlias : this.getDeviceAlias();
                    RegistrationInfo info = RegistrationInfo.fromContext(this.getContext(), platform, this.getDeviceUDID(), newDeviceAlias, pushToken);
                    info.printLog();
                    String registrationHash = this.encrypt(info.toString());
                    if (!this.isDeviceRegistered() || !Strings.equals(registrationHash, this.getRegistrationHash())) {
                        Ln.d("Registration changed! Launching new registration request", new Object[0]);
                        RegistrationMode registrationMode = this.getRegistrationMode();
                        Ln.d("Using registration mode: %s", new Object[]{registrationMode});
                        switch (registrationMode) {
                            case INTERNAL: {
                                this.launchRegistrationRequest(info);
                                break;
                            }
                            case EXTERNAL: {
                                RegistrationIntentReceiver.launchExternalRegistrationIntent(this.getContext(), info);
                                break;
                            }
                            default: {
                                this.registerError(new Exception("Registration mode not supported: " + (Object)((Object)registrationMode)));
                                break;
                            }
                        }
                    } else {
                        Ln.d("Registration info did not change since last registration", new Object[0]);
                        this.notifySuccess(deviceAlias);
                    }
                });
            } else {
                this.registerError(new Exception("Application ID is not setup in TwinPush SDK"));
            }
        });
    }

    @Override
    public void unregister() {
        this.setDeviceId(null);
        this.setDeviceAlias(null);
        this.setRegistrationHash(null);
    }

    @Override
    public void onRegistrationSuccess(@NonNull String deviceId, @NonNull RegistrationInfo info) {
        this.setDeviceId(deviceId);
        this.setDeviceAlias(this.deviceAlias);
        this.setRegistrationHash(this.encrypt(info.toString()));
        Ln.i("Device successfully registered on TwinPush (deviceId:%s, alias:%s)", deviceId, info.getDeviceAlias());
        this.notifySuccess(info.getDeviceAlias());
    }

    private void launchRegistrationRequest(final RegistrationInfo info) {
        if (this.getApiKey() != null) {
            if (this.registerRequest != null) {
                this.registerRequest.cancel();
            }
            this.registerRequest = this.getRequestFactory().register(info, new RegisterRequest.Listener(){

                @Override
                public void onError(Exception exception) {
                    DefaultTwinPushSDK.this.registerRequest = null;
                    DefaultTwinPushSDK.this.registerError(exception);
                }

                @Override
                public void onRegistrationSuccess(String deviceId, String deviceAlias) {
                    DefaultTwinPushSDK.this.registerRequest = null;
                    DefaultTwinPushSDK.this.onRegistrationSuccess(deviceId, info);
                }
            });
        } else {
            this.registerError(new Exception("API Key is not setup in TwinPush SDK"));
        }
    }

    private void notifySuccess(String deviceAlias) {
        if (this.registrationListener != null) {
            Handler mainHandler = new Handler(Looper.getMainLooper());
            mainHandler.post(() -> {
                if (this.registrationListener != null) {
                    this.registrationListener.onRegistrationSuccess(deviceAlias);
                    this.registrationListener = null;
                }
            });
        }
    }

    private void registerError(Exception e) {
        Ln.e(e);
        if (this.registrationListener != null) {
            Handler mainHandler = new Handler(Looper.getMainLooper());
            mainHandler.post(() -> {
                if (this.registrationListener != null) {
                    this.registrationListener.onRegistrationError(e);
                    this.registrationListener = null;
                }
            });
        }
    }

    @Override
    public void getNotifications(int page, int resultsPerPage, List<String> tags, List<String> noTags, boolean ignoreNonRichNotifications, GetNotificationsRequest.Listener listener) {
        this.getRequestFactory().getNotificationInbox(page, resultsPerPage, tags, noTags, ignoreNonRichNotifications, listener);
    }

    @Override
    public void getNotifications(int page, int resultsPerPage, GetNotificationsRequest.Listener listener) {
        this.getNotifications(page, resultsPerPage, null, null, true, listener);
    }

    @Override
    public void getUserInbox(int page, int resultsPerPage, GetInboxRequest.Listener listener) {
        this.getRequestFactory().getUserInbox(page, resultsPerPage, null, null, listener);
    }

    @Override
    public void getUserInbox(int page, int resultsPerPage, List<String> tags, List<String> noTags, GetInboxRequest.Listener listener) {
        this.getRequestFactory().getUserInbox(page, resultsPerPage, tags, noTags, listener);
    }

    @Override
    public void getUserInboxSummary(GetInboxSummaryRequest.Listener listener) {
        this.getRequestFactory().getUserInboxSummary(listener);
    }

    @Override
    public void getNotification(String notificationId, GetNotificationDetailsRequest.Listener listener) {
        this.getRequestFactory().getNotification(notificationId, listener);
    }

    @Override
    public void deleteNotification(InboxNotification notification, TwinRequest.DefaultListener listener) {
        this.getRequestFactory().deleteNotification(notification, listener);
    }

    @Override
    public void setBadgeCount(int badgeCount) {
        this.getRequestFactory().setBadgeCount(badgeCount, this.getDefaultListener("Set badge count"));
    }

    @Override
    public void getBadgeCount(GetBadgeCountRequest.Listener listener) {
        this.getRequestFactory().getBadgeCount(listener);
    }

    @Override
    public void setProperty(String name, String value) {
        this.setProperty(name, value, PropertyType.STRING, null);
    }

    @Override
    public void setProperty(String name, Boolean value) {
        this.setProperty(name, value, PropertyType.BOOLEAN, null);
    }

    @Override
    public void setProperty(String name, Integer value) {
        this.setProperty(name, value, PropertyType.INTEGER, null);
    }

    @Override
    public void setProperty(String name, Float value) {
        this.setProperty(name, value, PropertyType.FLOAT, null);
    }

    @Override
    public void setProperty(String name, Double value) {
        this.setProperty(name, value, PropertyType.FLOAT, null);
    }

    @Override
    public void setEnumProperty(String name, String value) {
        this.setProperty(name, value, PropertyType.ENUM, null);
    }

    @Override
    public void setProperty(String name, List<String> value) {
        this.setProperty(name, value, PropertyType.ENUM_LIST, null);
    }

    @Override
    public void setProperty(String name, Object value, PropertyType type, TwinRequest.DefaultListener listener) {
        TwinRequest.DefaultListener requestListener;
        TwinRequest.DefaultListener defaultListener = listener != null ? listener : (requestListener = this.getDefaultListener(String.format("Set property '%s' = '%s'", name, value == null ? "null" : value.toString())));
        if (this.isDeviceRegistered()) {
            this.getRequestFactory().setCustomProperty(name, type, value, requestListener);
        } else {
            requestListener.onError(new Exception("Not launching 'Set custom property': Device unregistered"));
        }
    }

    @Override
    public void clearProperties() {
        this.clearProperties(null);
    }

    @Override
    public void clearProperties(TwinRequest.DefaultListener listener) {
        TwinRequest.DefaultListener requestListener;
        TwinRequest.DefaultListener defaultListener = requestListener = listener != null ? listener : this.getDefaultListener("Clear properties");
        if (this.isDeviceRegistered()) {
            this.getRequestFactory().clearCustomProperties(requestListener);
        } else {
            requestListener.onError(new Exception("Not launching 'Clear custom properties': Device unregistered"));
        }
    }

    @Override
    public void setLocation(double latitude, double longitude) {
        Location location = new Location("USER_ENTRY");
        location.setLatitude(latitude);
        location.setLongitude(longitude);
        location.setTime(new Date().getTime());
        this.setLocation(location);
    }

    @Override
    public void setLocation(Location location) {
        double latitude = location.getLatitude();
        double longitude = location.getLongitude();
        this.setLastKnownLocation(location);
        TwinRequest.DefaultListener listener = this.getDefaultListener("Update location");
        if (this.isDeviceRegistered()) {
            this.getRequestFactory().reportStatistics(latitude, longitude, listener);
        } else {
            Ln.w("Not launching 'Location update': Device unregistered", new Object[0]);
        }
    }

    @Override
    public void updateLocation() {
        this.updateLocation(LocationPrecision.MEDIUM);
    }

    @Override
    public void updateLocation(LocationPrecision precision) {
        Location location = this.locationFinder.getLastBestLocation(precision.getMinUpdateDistance(), precision.getMinUpdateTime());
        if (location != null) {
            this.setLocation(location.getLatitude(), location.getLongitude());
        }
    }

    private PendingIntent getBackgroundLocationIntent() {
        Intent passiveIntent = new Intent(this.getContext(), LocationChangeReceiver.class);
        int flags = Build.VERSION.SDK_INT >= 23 ? 0xC000000 : 0x8000000;
        return PendingIntent.getBroadcast((Context)this.getContext(), (int)0, (Intent)passiveIntent, (int)flags);
    }

    @Override
    public void startMonitoringLocationChanges() {
        this.startMonitoringLocationChanges(LocationPrecision.MEDIUM);
    }

    @Override
    public void startMonitoringLocationChanges(LocationPrecision precision) {
        Ln.i("Registering for location updates", new Object[0]);
        this.getSharedPreferences().edit().putLong(PREF_LOCATION_MIN_UPDATE_TIME, precision.getMinUpdateTime()).putInt(PREF_LOCATION_MIN_UPDATE_DISTANCE, precision.getMinUpdateDistance()).apply();
        this.setMonitoringLocationChanges(true);
        this.registerForLocationUpdates();
    }

    @Override
    public void stopMonitoringLocationChanges() {
        LocationManager locationManager;
        this.setMonitoringLocationChanges(false);
        if ((ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == 0 || ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.ACCESS_COARSE_LOCATION") == 0) && (locationManager = (LocationManager)this.getContext().getSystemService("location")) != null) {
            locationManager.removeUpdates(this.getBackgroundLocationIntent());
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void registerForLocationUpdates() {
        if (ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == 0 || ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.ACCESS_COARSE_LOCATION") == 0) {
            LocationManager locationManager = (LocationManager)this.getContext().getSystemService("location");
            if (locationManager != null) {
                locationManager.requestLocationUpdates("passive", this.getLocationMinUpdateTime(), (float)this.getLocationMinUpdateDistance(), this.getBackgroundLocationIntent());
            }
        } else {
            Ln.e("Could not start location updates, required permissions not found", new Object[0]);
        }
    }

    private void setMonitoringLocationChanges(boolean monitoring) {
        this.getSharedPreferences().edit().putBoolean(PREF_MONITOR_LOCATION_CHANGES, monitoring).apply();
    }

    @Override
    public boolean isMonitoringLocationChanges() {
        return this.getSharedPreferences().getBoolean(PREF_MONITOR_LOCATION_CHANGES, false);
    }

    @Override
    public void activityStart(Activity activity) {
        if (this.openedActivities.isEmpty()) {
            this.onApplicationOpen();
        }
        if (!this.openedActivities.contains(activity)) {
            this.openedActivities.add(activity);
        }
    }

    @Override
    public void activityStop(Activity activity) {
        this.openedActivities.remove(activity);
        if (this.openedActivities.isEmpty()) {
            this.onApplicationClose();
        }
    }

    private void onApplicationOpen() {
        if (this.isDeviceRegistered()) {
            TwinRequest.DefaultListener listener = this.getDefaultListener("On Application Open");
            this.getRequestFactory().openApp(listener);
        } else {
            Ln.w("Not launching 'On application open event': Device unregistered", new Object[0]);
        }
    }

    private void onApplicationClose() {
        if (this.isDeviceRegistered()) {
            TwinRequest.DefaultListener listener = this.getDefaultListener("On Application Close");
            this.getRequestFactory().closeApp(listener);
        } else {
            Ln.w("Not launching 'On application close event': Device unregistered", new Object[0]);
        }
    }

    @Override
    public void onNotificationOpen(String notificationId) {
        if (notificationId != null) {
            TwinRequest.DefaultListener listener = this.getDefaultListener(String.format("On Notification Open: %s", notificationId));
            this.getRequestFactory().openNotification(notificationId, listener);
        }
    }

    @Override
    public void onNotificationOpen(PushNotification notification) {
        if (notification != null) {
            this.onNotificationOpen(notification.getId());
        }
    }

    @Override
    public void onNotificationReceived(PushNotification notification) {
        if (notification != null) {
            this.onNotificationReceived(notification.getId());
        }
    }

    @Override
    public void onNotificationReceived(String notificationId) {
        if (notificationId != null) {
            TwinRequest.DefaultListener listener = this.getDefaultListener(String.format("On Notification Received: %s", notificationId));
            this.getRequestFactory().onReceivedNotification(notificationId, listener);
        }
    }

    private SharedPreferences getSharedPreferences() {
        return this.getSharedPreferences(PREF_FILE_NAME);
    }

    private SharedPreferences getSharedPreferences(String preferencesName) {
        SharedPreferences prefs = this.sharedPreferencesMap.get(preferencesName);
        if (prefs == null) {
            prefs = new SecurePreferences(this.getContext(), "", String.format(Locale.ENGLISH, "%sSec", preferencesName));
            SharedPreferences oldPrefs = this.getContext().getSharedPreferences(preferencesName, 0);
            if (!oldPrefs.getAll().isEmpty()) {
                this.securePreferences(prefs, oldPrefs);
            }
            this.sharedPreferencesMap.put(preferencesName, prefs);
        }
        return prefs;
    }

    private void securePreferences(SharedPreferences securePreferences, SharedPreferences oldPrefs) {
        SharedPreferences.Editor editor = securePreferences.edit();
        if (!oldPrefs.getAll().isEmpty()) {
            for (Map.Entry entry : oldPrefs.getAll().entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    editor.putString((String)entry.getKey(), (String)value);
                    continue;
                }
                if (value instanceof Integer) {
                    editor.putInt((String)entry.getKey(), ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Long) {
                    editor.putLong((String)entry.getKey(), ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Float) {
                    editor.putFloat((String)entry.getKey(), ((Float)value).floatValue());
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                editor.putBoolean((String)entry.getKey(), ((Boolean)value).booleanValue());
            }
            editor.apply();
            oldPrefs.edit().clear().apply();
        }
    }

    public Context getContext() {
        return this._context;
    }

    @Override
    public String getDeviceAlias() {
        if (this.deviceAlias == null) {
            this.deviceAlias = this.decrypt(this.getSharedPreferences().getString(PREF_DEVICE_ALIAS, null));
        }
        return this.deviceAlias;
    }

    private void setDeviceAlias(String deviceAlias) {
        this.getSharedPreferences().edit().putString(PREF_DEVICE_ALIAS, this.encrypt(deviceAlias)).apply();
        this.deviceAlias = deviceAlias;
    }

    @Override
    public String getDeviceId() {
        if (this.deviceId == null) {
            this.deviceId = this.getSharedPreferences().getString(PREF_DEVICE_ID, null);
        }
        return this.deviceId;
    }

    private void setDeviceId(String deviceId) {
        this.getSharedPreferences().edit().putString(PREF_DEVICE_ID, deviceId).apply();
        this.deviceId = deviceId;
    }

    @Override
    public String getApiKey() {
        if (this.apiKey == null) {
            this.apiKey = this.getSharedPreferences().getString(PREF_TWINPUSH_API_KEY, null);
        }
        return this.apiKey;
    }

    private void setApiKey(String apiKey) {
        this.getSharedPreferences().edit().putString(PREF_TWINPUSH_API_KEY, apiKey).apply();
        this.apiKey = apiKey;
    }

    @Override
    public String getAppId() {
        if (this.appId == null) {
            this.appId = this.getSharedPreferences().getString(PREF_TWINPUSH_APP_ID, null);
        }
        return this.appId;
    }

    private void setAppId(String appId) {
        this.getSharedPreferences().edit().putString(PREF_TWINPUSH_APP_ID, appId).apply();
        this.appId = appId;
    }

    @Override
    public long getLocationMinUpdateTime() {
        return this.getSharedPreferences().getLong(PREF_LOCATION_MIN_UPDATE_TIME, 0L);
    }

    @Override
    public int getLocationMinUpdateDistance() {
        return this.getSharedPreferences().getInt(PREF_LOCATION_MIN_UPDATE_DISTANCE, 0);
    }

    @Override
    public void setDeviceUDID(String deviceUDID) {
        this.getSharedPreferences().edit().putString(PREF_DEVICE_UDID, deviceUDID).apply();
    }

    @SuppressLint(value={"HardwareIds"})
    private String getDeviceUDID() {
        return this.getSharedPreferences().getString(PREF_DEVICE_UDID, Settings.Secure.getString((ContentResolver)this.getContext().getContentResolver(), (String)"android_id"));
    }

    @Override
    public boolean setup(TwinPushOptions options) {
        if (options != null) {
            boolean validHost;
            String appId = options.twinPushAppId;
            String subdomain = options.subdomain;
            String serverHost = options.serverHost;
            RegistrationMode registrationMode = options.registrationMode;
            boolean bl = validHost = Strings.notEmpty(subdomain) || Strings.notEmpty(serverHost);
            if (Strings.notEmpty(appId)) {
                if (registrationMode != null) {
                    if (Strings.notEmpty(options.twinPushApiKey) || registrationMode != RegistrationMode.INTERNAL) {
                        if (validHost) {
                            String prevAppId = this.getAppId();
                            if (Strings.notEmpty(prevAppId) && !Strings.equals(appId, prevAppId)) {
                                this.unregister();
                            }
                            this.setAppId(options.twinPushAppId);
                            this.setApiKey(options.twinPushApiKey);
                            this.setRegistrationMode(options.registrationMode);
                            this.setPushAckEnabled(options.pushAckEnabled);
                            this.setPreferredPlatform(options.preferredPlatform);
                            this.setSilentReceiverClass(options.silentPushReceiverClass);
                            if (options.serverHost != null) {
                                this.setServerHost(options.serverHost);
                            } else {
                                this.setSubdomain(options.subdomain);
                            }
                            this.resetSSLChecks();
                            this.createNotificationChannel();
                            return true;
                        }
                        Ln.e("TwinPush Setup Error: subdomain or serverHost are required", new Object[0]);
                    } else {
                        Ln.e("TwinPush Setup Error: API Key is required for Internal registrarion mode", new Object[0]);
                    }
                } else {
                    Ln.e("TwinPush Setup Error: registration mode can not be null", new Object[0]);
                }
            } else {
                Ln.e("TwinPush Setup Error: App ID info is missing", new Object[0]);
            }
        } else {
            Ln.e("TwinPush Setup Error: options object is null", new Object[0]);
        }
        return false;
    }

    @Override
    public void createNotificationChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(this.getContext().getString(R.string.twinPush_default_channel_id), (CharSequence)this.getContext().getString(R.string.twinPush_default_channel_name), this.getContext().getResources().getInteger(R.integer.twinPush_default_channel_importance));
            NotificationManager manager = (NotificationManager)this.getContext().getSystemService("notification");
            if (manager != null) {
                manager.createNotificationChannel(channel);
            }
        }
    }

    private TwinPushRequestFactory getRequestFactory() {
        return TwinPushRequestFactory.getSharedinstance(this.getContext());
    }

    private TwinRequest.DefaultListener getDefaultListener(final String requestName) {
        return new TwinRequest.DefaultListener(){

            @Override
            public void onError(Exception exception) {
                Ln.e(exception, (Object)String.format("Error while trying to send %s request", requestName), new Object[0]);
            }

            @Override
            public void onSuccess() {
                Ln.i("Successfuly sent %s request", requestName);
            }
        };
    }

    private void setLastKnownLocation(Location location) {
        if (location != null) {
            this.getSharedPreferences().edit().putFloat(PREF_LOCATION_LATITUDE, (float)location.getLatitude()).putFloat(PREF_LOCATION_LONGITUDE, (float)location.getLongitude()).putFloat(PREF_LOCATION_ALTITUDE, (float)location.getAltitude()).putFloat(PREF_LOCATION_ACCURACY, location.getAccuracy()).putLong(PREF_LOCATION_TIME, location.getTime()).putString(PREF_LOCATION_PROVIDER, location.getProvider()).apply();
        }
    }

    @Override
    public Location getLastKnownLocation() {
        Location location = null;
        SharedPreferences pref = this.getSharedPreferences();
        long time = pref.getLong(PREF_LOCATION_TIME, 0L);
        if (time > 0L) {
            float latitude = pref.getFloat(PREF_LOCATION_LATITUDE, 0.0f);
            float longitude = pref.getFloat(PREF_LOCATION_LONGITUDE, 0.0f);
            float altitude = pref.getFloat(PREF_LOCATION_ALTITUDE, 0.0f);
            float accuracy = pref.getFloat(PREF_LOCATION_ACCURACY, 0.0f);
            String provider = pref.getString(PREF_LOCATION_PROVIDER, "");
            location = new Location(provider);
            location.setAccuracy(accuracy);
            location.setLatitude((double)latitude);
            location.setLongitude((double)longitude);
            location.setAltitude((double)altitude);
            location.setTime(time);
        }
        return location;
    }

    public void onLocationChanged(Location location) {
        this.setLocation(location.getLatitude(), location.getLongitude());
    }

    public void onProviderDisabled(String provider) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    public boolean isDeviceRegistered() {
        return this.getDeviceId() != null;
    }

    private void resetSSLChecks() {
        this.setSSLPublicKeyCheck(null);
        this.getSharedPreferences(PREF_SSL_ISSUER).edit().clear().apply();
        this.getSharedPreferences(PREF_SSL_SUBJECT).edit().clear().apply();
    }

    @Override
    public void setSSLPublicKeyCheck(String encodedKey) {
        this.getSharedPreferences().edit().putString(PREF_SSL_PUBLIC_KEY, encodedKey).apply();
    }

    @Override
    public String getSSLPublicKeyCheck() {
        return this.getSharedPreferences().getString(PREF_SSL_PUBLIC_KEY, null);
    }

    @Override
    public void addSSLIssuerCheck(String field, String expectedValue) {
        this.getSharedPreferences(PREF_SSL_ISSUER).edit().putString(field, expectedValue).apply();
    }

    @Override
    public void addSSLSubjectCheck(String field, String expectedValue) {
        this.getSharedPreferences(PREF_SSL_SUBJECT).edit().putString(field, expectedValue).apply();
    }

    @Override
    public Map<String, String> getSSLIssuerChecks() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : this.getSharedPreferences(PREF_SSL_ISSUER).getAll().entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return map;
    }

    @Override
    public Map<String, String> getSSLSubjectChecks() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : this.getSharedPreferences(PREF_SSL_SUBJECT).getAll().entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return map;
    }

    private String encrypt(String rawValue) {
        if (rawValue != null) {
            try {
                return new StringEncrypter(this.getDeviceUDID()).encryptString(rawValue);
            }
            catch (Exception e) {
                Ln.e(e, (Object)"Error trying to encrypt string", new Object[0]);
            }
        }
        return null;
    }

    private String decrypt(String encryptedValue) {
        if (encryptedValue != null) {
            try {
                return new StringEncrypter(this.getDeviceUDID()).decryptString(encryptedValue);
            }
            catch (Exception e) {
                Ln.e(e, (Object)"Error trying to decrypt string", new Object[0]);
            }
        }
        return null;
    }

    private void setSubdomain(String subdomain) {
        this.getSharedPreferences().edit().putString(PREF_TWINPUSH_SUBDOMAIN, subdomain).apply();
    }

    @Override
    public String getSubdomain() {
        return this.getSharedPreferences().getString(PREF_TWINPUSH_SUBDOMAIN, DEFAULT_SUBDOMAIN);
    }

    private void setServerHost(String serverHost) {
        this.getSharedPreferences().edit().putString(PREF_TWINPUSH_CUSTOM_HOST, serverHost).apply();
    }

    @Override
    public String getServerHost() {
        return this.getSharedPreferences().getString(PREF_TWINPUSH_CUSTOM_HOST, String.format(DEFAULT_HOST, this.getSubdomain()));
    }

    private void setRegistrationHash(String registrationHash) {
        this.getSharedPreferences().edit().putString(PREF_REGISTRATION_HASH, registrationHash).apply();
    }

    private String getRegistrationHash() {
        return this.getSharedPreferences().getString(PREF_REGISTRATION_HASH, null);
    }

    private void setRegistrationMode(@NonNull RegistrationMode registrationMode) {
        this.getSharedPreferences().edit().putInt(PREF_REGISTRATION_MODE, registrationMode.getId()).apply();
    }

    private RegistrationMode getRegistrationMode() {
        return RegistrationMode.fromId(this.getSharedPreferences().getInt(PREF_REGISTRATION_MODE, RegistrationMode.INTERNAL.getId()));
    }

    private void setPushAckEnabled(boolean pushAckEnabled) {
        if (pushAckEnabled) {
            this.getSharedPreferences().edit().putBoolean(PREF_PUSH_ACK_ENABLED, pushAckEnabled).apply();
        } else {
            this.getSharedPreferences().edit().remove(PREF_PUSH_ACK_ENABLED).apply();
        }
    }

    @NonNull
    private Platform getPreferredPlatform() {
        try {
            return Platform.valueOf(this.getSharedPreferences().getString(PREF_PREFERRED_PLATFORM, Platform.ANDROID.toString()));
        }
        catch (Exception exception) {
            return Platform.ANDROID;
        }
    }

    private void setPreferredPlatform(@NonNull Platform platform) {
        this.getSharedPreferences().edit().putString(PREF_PREFERRED_PLATFORM, platform.toString()).apply();
    }

    @Override
    public boolean isPushAckEnabled() {
        return this.getSharedPreferences().getBoolean(PREF_PUSH_ACK_ENABLED, false);
    }

    private void setSilentReceiverClass(Class<? extends SilentPushReceiver> receiver) {
        if (receiver != null) {
            this.getSharedPreferences().edit().putString(PREF_SILENT_RECEIVER, receiver.getCanonicalName()).apply();
        } else {
            this.getSharedPreferences().edit().remove(PREF_SILENT_RECEIVER).apply();
        }
    }

    public Class<? extends SilentPushReceiver> getSilentReceiverClass() {
        String className = this.getSharedPreferences().getString(PREF_SILENT_RECEIVER, null);
        if (className != null) {
            try {
                return Class.forName(className).asSubclass(SilentPushReceiver.class);
            }
            catch (ClassNotFoundException e) {
                Ln.e(e, (Object)"Error trying to obtain notification receiver class", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public SilentPushReceiver getSilentReceiver() {
        Class<? extends SilentPushReceiver> receiverClass = this.getSilentReceiverClass();
        if (receiverClass != null) {
            try {
                return receiverClass.newInstance();
            }
            catch (Exception ex) {
                Ln.e(ex, (Object)"Error trying to obtain notification receiver class", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public FirebaseApp getFirebaseApp() {
        if (this.firebase == null) {
            String firebaseAppId = this.getContext().getString(R.string.fcmMobileAppId);
            if (Strings.notEmpty(firebaseAppId)) {
                FirebaseOptions options = new FirebaseOptions.Builder().setApplicationId(firebaseAppId).setProjectId(this.getContext().getString(R.string.fcmProjectId)).setApiKey(this.getContext().getString(R.string.fcmApiKey)).setGcmSenderId(this.getContext().getString(R.string.fcmProjectNumber)).build();
                if (!this.isDefaultFirebaseInitialized()) {
                    Ln.i("Using customized Firebase App as PRIMARY with ID %s", firebaseAppId);
                    FirebaseApp.initializeApp((Context)this.getContext(), (FirebaseOptions)options);
                    this.firebase = FirebaseApp.getInstance();
                } else {
                    Ln.i("Using customized Firebase App as SECONDARY with ID %s", firebaseAppId);
                    FirebaseApp.initializeApp((Context)this.getContext(), (FirebaseOptions)options, (String)FIREBASE_NAME);
                    this.firebase = FirebaseApp.getInstance((String)FIREBASE_NAME);
                }
            } else {
                this.firebase = FirebaseApp.getInstance();
                Ln.i("Using DEFAULT Firebase App", new Object[0]);
            }
        }
        return this.firebase;
    }

    private boolean isDefaultFirebaseInitialized() {
        boolean hasBeenInitialized = false;
        List firebaseApps = FirebaseApp.getApps((Context)this.getContext());
        for (FirebaseApp app : firebaseApps) {
            if (!app.getName().equals(FIREBASE_DEFAULT_APP_NAME)) continue;
            hasBeenInitialized = true;
        }
        return hasBeenInitialized;
    }

    @Override
    public void getFirebaseToken(@NonNull TwinPushSDK.GetTokenListener listener) {
        Ln.d("Requesting FCM Token...", new Object[0]);
        this.getFirebaseApp();
        FirebaseMessaging.getInstance().getToken().addOnCompleteListener(task -> {
            if (!task.isSuccessful()) {
                Ln.w("Fetching FCM registration token failed", task.getException());
                return;
            }
            String token = (String)task.getResult();
            Ln.d("FCM Token fetched: %s", token);
            listener.onTokenSuccess(token);
        });
    }

    @Nullable
    private String getHMSToken() {
        try {
            String appId = new AGConnectOptionsBuilder().build(this.getContext()).getString("client/app_id");
            String token = HmsInstanceId.getInstance((Context)this.getContext()).getToken(appId, "HCM");
            Ln.i("Obtained HMS Token: %s:", token);
            return token;
        }
        catch (ApiException e) {
            Ln.e(e, (Object)"Error obtaining HMS push token", new Object[0]);
            return null;
        }
    }

    private void getPlatformAndToken(final @NonNull GetTokenAndPlatformListener listener) {
        String pushToken;
        Platform selectedPlatform;
        ArrayList<Platform> availablePlatforms = new ArrayList<Platform>();
        if (this.isGoogleServicesAvailable()) {
            availablePlatforms.add(Platform.ANDROID);
        }
        if (this.isHuaweiServicesAvailable()) {
            availablePlatforms.add(Platform.HUAWEI);
        }
        Platform preferredPlatform = this.getPreferredPlatform();
        if (availablePlatforms.isEmpty()) {
            selectedPlatform = preferredPlatform;
            pushToken = null;
        } else {
            selectedPlatform = availablePlatforms.contains((Object)this.getPreferredPlatform()) ? this.getPreferredPlatform() : (Platform)((Object)availablePlatforms.get(0));
            switch (selectedPlatform) {
                case HUAWEI: {
                    pushToken = this.getHMSToken();
                    break;
                }
                default: {
                    this.getFirebaseToken(new TwinPushSDK.GetTokenListener(){

                        @Override
                        public void onTokenError(Exception exception) {
                            Ln.e(exception, (Object)"Error trying to obtain push token", new Object[0]);
                            listener.onResult(selectedPlatform, null);
                        }

                        @Override
                        public void onTokenSuccess(String token) {
                            listener.onResult(selectedPlatform, token);
                        }
                    });
                    return;
                }
            }
        }
        listener.onResult(selectedPlatform, pushToken);
    }

    private boolean isGoogleServicesAvailable() {
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(this.getContext()) == 0;
    }

    private boolean isHuaweiServicesAvailable() {
        return HuaweiMobileServicesUtil.isHuaweiMobileServicesAvailable((Context)this.getContext()) == 0 || HuaweiMobileServicesUtil.isHuaweiMobileServicesAvailable((Context)this.getContext()) == 2;
    }

    public static interface GetTokenAndPlatformListener {
        public void onResult(Platform var1, String var2);
    }
}

