/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Looper;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import com.turingtechnologies.materialscrollbar.MaterialScrollBar;
import com.turingtechnologies.materialscrollbar.R;

public class TouchScrollBar
extends MaterialScrollBar<TouchScrollBar> {
    private boolean hide = true;
    private int hideDuration = 2500;
    private Handler uiHandler = new Handler(Looper.getMainLooper());
    private Runnable fadeBar = new Runnable(){

        @Override
        public void run() {
            TouchScrollBar.this.fadeOut();
        }
    };

    public TouchScrollBar(Context context, RecyclerView recyclerView, boolean lightOnTouch) {
        super(context, recyclerView, lightOnTouch);
    }

    public TouchScrollBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public TouchScrollBar(Context context, AttributeSet attributeSet, int defStyle) {
        super(context, attributeSet, defStyle);
    }

    public TouchScrollBar setHideDuration(int duration) {
        this.hideDuration = duration;
        return this;
    }

    @Override
    void setTouchIntercept() {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (!TouchScrollBar.this.hiddenByUser) {
                    if (event.getAction() != 1) {
                        TouchScrollBar.this.onDown(event);
                        if (TouchScrollBar.this.hide) {
                            TouchScrollBar.this.uiHandler.removeCallbacks(TouchScrollBar.this.fadeBar);
                            TouchScrollBar.this.fadeIn();
                        }
                    } else {
                        TouchScrollBar.this.onUp();
                        if (TouchScrollBar.this.hide) {
                            TouchScrollBar.this.uiHandler.removeCallbacks(TouchScrollBar.this.fadeBar);
                            TouchScrollBar.this.uiHandler.postDelayed(TouchScrollBar.this.fadeBar, (long)TouchScrollBar.this.hideDuration);
                        }
                    }
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    int getMode() {
        return 1;
    }

    @Override
    float getHideRatio() {
        return 1.0f;
    }

    @Override
    void onScroll() {
        if (this.hide) {
            this.uiHandler.removeCallbacks(this.fadeBar);
            this.uiHandler.postDelayed(this.fadeBar, (long)this.hideDuration);
            this.fadeIn();
        }
    }

    @Override
    boolean getHide() {
        return true;
    }

    @Override
    void implementFlavourPreferences(TypedArray a) {
        if (a.hasValue(R.styleable.TouchScrollBar_autoHide)) {
            this.setAutoHide(a.getBoolean(R.styleable.TouchScrollBar_autoHide, true));
        }
        if (a.hasValue(R.styleable.TouchScrollBar_hideDelayInMilliseconds)) {
            this.hideDuration = a.getInteger(R.styleable.TouchScrollBar_hideDelayInMilliseconds, 2500);
        }
    }

    @Override
    float getHandleOffset() {
        return 0.0f;
    }

    @Override
    float getIndicatorOffset() {
        return 0.0f;
    }

    public MaterialScrollBar setAutoHide(Boolean hide) {
        if (!hide.booleanValue()) {
            TranslateAnimation anim = new TranslateAnimation(2, 0.0f, 1, 0.0f, 2, 0.0f, 2, 0.0f);
            anim.setFillAfter(true);
            this.startAnimation((Animation)anim);
        }
        this.hide = hide;
        return this;
    }
}

