/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import com.turingtechnologies.materialscrollbar.MaterialScrollBar;
import com.turingtechnologies.materialscrollbar.R;
import com.turingtechnologies.materialscrollbar.Utils;

public class TouchScrollBar
extends MaterialScrollBar<TouchScrollBar> {
    private boolean hide = true;
    private int hideDuration = 2500;
    private Handler uiHandler = new Handler(Looper.getMainLooper());
    private Runnable fadeBar = new Runnable(){

        @Override
        public void run() {
            TouchScrollBar.this.fadeOut();
        }
    };

    public TouchScrollBar(Context context, RecyclerView recyclerView, boolean lightOnTouch) {
        super(context, recyclerView, lightOnTouch);
    }

    public TouchScrollBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public TouchScrollBar(Context context, AttributeSet attributeSet, int defStyle) {
        super(context, attributeSet, defStyle);
    }

    public TouchScrollBar setHideDuration(int duration) {
        this.hideDuration = duration;
        return this;
    }

    @Override
    void setTouchIntercept() {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (!TouchScrollBar.this.hiddenByUser) {
                    if (event.getAction() != 1) {
                        if (TouchScrollBar.this.indicator != null && TouchScrollBar.this.indicator.getVisibility() == 4) {
                            TouchScrollBar.this.indicator.setVisibility(0);
                            if (Build.VERSION.SDK_INT >= 12) {
                                TouchScrollBar.this.indicator.setAlpha(0.0f);
                                TouchScrollBar.this.indicator.animate().alpha(1.0f).setDuration(150L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                                    @TargetApi(value=11)
                                    public void onAnimationEnd(Animator animation) {
                                        super.onAnimationEnd(animation);
                                        TouchScrollBar.this.indicator.setAlpha(1.0f);
                                    }
                                });
                            }
                        }
                        int top = TouchScrollBar.this.handle.getHeight() / 2;
                        int bottom = TouchScrollBar.this.recyclerView.getHeight() - Utils.getDP(72, TouchScrollBar.this.recyclerView.getContext());
                        float boundedY = Math.max((float)top, Math.min((float)bottom, event.getY()));
                        TouchScrollBar.this.scrollUtils.scrollToPositionAtProgress((boundedY - (float)top) / (float)(bottom - top));
                        TouchScrollBar.this.scrollUtils.scrollHandleAndIndicator();
                        TouchScrollBar.this.recyclerView.onScrolled(0, 0);
                        if (TouchScrollBar.this.lightOnTouch) {
                            TouchScrollBar.this.handle.setBackgroundColor(TouchScrollBar.this.handleColour);
                        }
                        if (TouchScrollBar.this.hide) {
                            TouchScrollBar.this.uiHandler.removeCallbacks(TouchScrollBar.this.fadeBar);
                            TouchScrollBar.this.fadeIn();
                        }
                    } else {
                        if (TouchScrollBar.this.indicator != null && TouchScrollBar.this.indicator.getVisibility() == 0) {
                            if (Build.VERSION.SDK_INT <= 12) {
                                TouchScrollBar.this.indicator.clearAnimation();
                            }
                            TouchScrollBar.this.indicator.setVisibility(4);
                        }
                        if (TouchScrollBar.this.lightOnTouch) {
                            TouchScrollBar.this.handle.setBackgroundColor(TouchScrollBar.this.handleOffColour);
                        }
                        if (TouchScrollBar.this.hide) {
                            TouchScrollBar.this.uiHandler.removeCallbacks(TouchScrollBar.this.fadeBar);
                            TouchScrollBar.this.uiHandler.postDelayed(TouchScrollBar.this.fadeBar, (long)TouchScrollBar.this.hideDuration);
                        }
                    }
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    int getMode() {
        return 1;
    }

    @Override
    float getHideRatio() {
        return 1.0f;
    }

    @Override
    void onScroll() {
        if (this.hide) {
            this.uiHandler.removeCallbacks(this.fadeBar);
            this.uiHandler.postDelayed(this.fadeBar, (long)this.hideDuration);
            this.fadeIn();
        }
    }

    @Override
    boolean getHide() {
        return true;
    }

    @Override
    void implementFlavourPreferences(TypedArray a) {
        if (a.hasValue(R.styleable.TouchScrollBar_autoHide)) {
            this.setAutoHide(a.getBoolean(R.styleable.TouchScrollBar_autoHide, true));
        }
        if (a.hasValue(R.styleable.TouchScrollBar_hideDelayInMilliseconds)) {
            this.hideDuration = a.getInteger(R.styleable.TouchScrollBar_hideDelayInMilliseconds, 2500);
        }
    }

    public MaterialScrollBar setAutoHide(Boolean hide) {
        if (!hide.booleanValue()) {
            TranslateAnimation anim = new TranslateAnimation(2, 0.0f, 1, 0.0f, 2, 0.0f, 2, 0.0f);
            anim.setFillAfter(true);
            this.startAnimation((Animation)anim);
        }
        this.hide = hide;
        return this;
    }
}

