/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.support.v4.view.ViewCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.view.View;
import com.turingtechnologies.materialscrollbar.MaterialScrollBar;

class ScrollingUtilities {
    MaterialScrollBar materialScrollBar;
    private ScrollPositionState scrollPosState = new ScrollPositionState();

    ScrollingUtilities(MaterialScrollBar msb) {
        this.materialScrollBar = msb;
    }

    protected void scrollHandleAndIndicator() {
        this.getCurScrollState();
        int scrollY = this.materialScrollBar.getPaddingTop() + this.scrollPosState.rowIndex * this.scrollPosState.rowHeight - this.scrollPosState.rowTopOffset;
        int scrollBarY = (int)((float)scrollY / (float)this.getAvailableScrollHeight() * (float)this.getAvailableScrollBarHeight());
        ViewCompat.setY((View)this.materialScrollBar.handle, (float)scrollBarY);
        this.materialScrollBar.handle.invalidate();
        if (this.materialScrollBar.indicator != null) {
            this.materialScrollBar.indicator.setScroll(scrollBarY + this.materialScrollBar.getTop(), this.materialScrollBar.programmatic);
            this.materialScrollBar.indicator.textView.setText((CharSequence)this.materialScrollBar.indicator.getTextElement(this.scrollPosState.rowIndex, this.materialScrollBar.recyclerView.getAdapter()));
        }
    }

    int getRowCount() {
        int rowCount = this.materialScrollBar.recyclerView.getLayoutManager().getItemCount();
        if (this.materialScrollBar.recyclerView.getLayoutManager() instanceof GridLayoutManager) {
            int spanCount = ((GridLayoutManager)this.materialScrollBar.recyclerView.getLayoutManager()).getSpanCount();
            rowCount = (int)Math.ceil((double)rowCount / (double)spanCount);
        }
        return rowCount;
    }

    protected int getAvailableScrollBarHeight() {
        int visibleHeight = this.materialScrollBar.getHeight();
        return visibleHeight - this.materialScrollBar.handle.getHeight();
    }

    public void scrollToPositionAtProgress(float touchFraction) {
        int spanCount = 1;
        if (this.materialScrollBar.recyclerView.getLayoutManager() instanceof GridLayoutManager) {
            spanCount = ((GridLayoutManager)this.materialScrollBar.recyclerView.getLayoutManager()).getSpanCount();
        }
        this.materialScrollBar.recyclerView.stopScroll();
        this.getCurScrollState();
        int exactItemPos = (int)((float)this.getAvailableScrollHeight() * touchFraction);
        LinearLayoutManager layoutManager = (LinearLayoutManager)this.materialScrollBar.recyclerView.getLayoutManager();
        layoutManager.scrollToPositionWithOffset(spanCount * exactItemPos / this.scrollPosState.rowHeight, -(exactItemPos % this.scrollPosState.rowHeight));
    }

    protected int getAvailableScrollHeight() {
        int visibleHeight = this.materialScrollBar.getHeight();
        int scrollHeight = this.materialScrollBar.getPaddingTop() + this.getRowCount() * this.scrollPosState.rowHeight + this.materialScrollBar.getPaddingBottom();
        return scrollHeight - visibleHeight;
    }

    public void getCurScrollState() {
        this.scrollPosState.rowIndex = -1;
        this.scrollPosState.rowTopOffset = -1;
        this.scrollPosState.rowHeight = -1;
        int itemCount = this.materialScrollBar.recyclerView.getAdapter().getItemCount();
        if (itemCount == 0) {
            return;
        }
        View child = this.materialScrollBar.recyclerView.getChildAt(0);
        this.scrollPosState.rowIndex = this.materialScrollBar.recyclerView.getChildAdapterPosition(child);
        if (this.materialScrollBar.recyclerView.getLayoutManager() instanceof GridLayoutManager) {
            this.scrollPosState.rowIndex /= ((GridLayoutManager)this.materialScrollBar.recyclerView.getLayoutManager()).getSpanCount();
        }
        this.scrollPosState.rowTopOffset = this.materialScrollBar.recyclerView.getLayoutManager().getDecoratedTop(child);
        this.scrollPosState.rowHeight = child.getHeight();
    }

    public class ScrollPositionState {
        public int rowIndex;
        public int rowTopOffset;
        public int rowHeight;
    }
}

