/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.nineoldandroids.view.ViewHelper;
import com.turingtechnologies.materialscrollbar.MaterialScrollBar;
import com.turingtechnologies.materialscrollbar.Utils;

public class DragScrollBar
extends MaterialScrollBar<DragScrollBar> {
    boolean held = false;

    public DragScrollBar(Context context, RecyclerView recyclerView, boolean lightOnTouch) {
        super(context, recyclerView, lightOnTouch);
    }

    public DragScrollBar(Context context, AttributeSet attributeSet, int defStyle) {
        super(context, attributeSet, defStyle);
    }

    public DragScrollBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    @Override
    void setTouchIntercept() {
        View.OnTouchListener otl = new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (!DragScrollBar.this.hiddenByUser) {
                    if (event.getAction() == 0 && event.getY() >= ViewHelper.getY((View)DragScrollBar.this.handle) - (float)Utils.getDP(20, DragScrollBar.this.recyclerView.getContext()) && event.getY() <= ViewHelper.getY((View)DragScrollBar.this.handle) + (float)DragScrollBar.this.handle.getHeight()) {
                        DragScrollBar.this.held = true;
                    }
                    if ((event.getAction() == 2 || event.getAction() == 0) && DragScrollBar.this.held) {
                        if (DragScrollBar.this.indicator != null && DragScrollBar.this.indicator.getVisibility() == 4) {
                            DragScrollBar.this.indicator.setVisibility(0);
                            if (Build.VERSION.SDK_INT >= 12) {
                                DragScrollBar.this.indicator.setAlpha(0.0f);
                                DragScrollBar.this.indicator.animate().alpha(1.0f).setDuration(150L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                                    @TargetApi(value=11)
                                    public void onAnimationEnd(Animator animation) {
                                        super.onAnimationEnd(animation);
                                        DragScrollBar.this.indicator.setAlpha(1.0f);
                                    }
                                });
                            }
                        }
                        int top = DragScrollBar.this.handle.getHeight() / 2;
                        int bottom = DragScrollBar.this.recyclerView.getHeight() - Utils.getDP(72, DragScrollBar.this.recyclerView.getContext());
                        float boundedY = Math.max((float)top, Math.min((float)bottom, event.getY()));
                        DragScrollBar.this.scrollUtils.scrollToPositionAtProgress((boundedY - (float)top) / (float)(bottom - top));
                        DragScrollBar.this.scrollUtils.scrollHandleAndIndicator();
                        DragScrollBar.this.recyclerView.onScrolled(0, 0);
                        if (DragScrollBar.this.lightOnTouch) {
                            DragScrollBar.this.handle.setBackgroundColor(DragScrollBar.this.handleColour);
                        }
                        DragScrollBar.this.fadeIn();
                    } else {
                        DragScrollBar.this.held = false;
                        if (DragScrollBar.this.indicator != null && DragScrollBar.this.indicator.getVisibility() == 0) {
                            if (Build.VERSION.SDK_INT <= 12) {
                                DragScrollBar.this.indicator.clearAnimation();
                            }
                            if (Build.VERSION.SDK_INT >= 12) {
                                DragScrollBar.this.indicator.animate().alpha(0.0f).setDuration(150L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                                    public void onAnimationEnd(Animator animation) {
                                        super.onAnimationEnd(animation);
                                        DragScrollBar.this.indicator.setVisibility(4);
                                    }
                                });
                            } else {
                                DragScrollBar.this.indicator.setVisibility(4);
                            }
                        }
                        if (DragScrollBar.this.lightOnTouch) {
                            DragScrollBar.this.handle.setBackgroundColor(DragScrollBar.this.handleOffColour);
                        }
                        DragScrollBar.this.fadeOut();
                    }
                    return true;
                }
                return false;
            }
        };
        this.setOnTouchListener(otl);
    }

    @Override
    int getMode() {
        return 0;
    }

    @Override
    float getHideRatio() {
        if (this.programmatic) {
            return 0.35f;
        }
        return 0.65f;
    }

    @Override
    void onScroll() {
    }

    @Override
    boolean getHide() {
        return true;
    }

    @Override
    void implementFlavourPreferences(TypedArray a) {
    }
}

