/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import com.nineoldandroids.view.ViewHelper;
import com.turingtechnologies.materialscrollbar.MaterialScrollBar;
import com.turingtechnologies.materialscrollbar.Utils;

public class TouchScrollBar
extends MaterialScrollBar {
    boolean hide = true;
    private int hideDuration = 2500;
    private Handler mUIHandler = new Handler(Looper.getMainLooper());
    private Runnable mFadeBar = new Runnable(){

        @Override
        public void run() {
            TouchScrollBar.this.fadeOut();
        }
    };

    public TouchScrollBar(Context context, RecyclerView recyclerView, boolean lightOnTouch) {
        super(context, recyclerView, lightOnTouch);
    }

    public TouchScrollBar setHideDuration(int duration) {
        this.hideDuration = duration;
        return this;
    }

    @Override
    void setTouchIntercept() {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (!TouchScrollBar.this.totallyHidden) {
                    if (event.getAction() != 1) {
                        TouchScrollBar.this.hold = true;
                        if (TouchScrollBar.this.recyclerView.getLayoutManager() instanceof GridLayoutManager && ((GridLayoutManager)TouchScrollBar.this.recyclerView.getLayoutManager()).getSpanCount() != 1) {
                            if (event.getRawY() - (float)(TouchScrollBar.this.handle.getHeight() * 3 / 2) >= ViewHelper.getY((View)TouchScrollBar.this.getMe()) && event.getRawY() - (float)(TouchScrollBar.this.handle.getHeight() / 2) <= (float)TouchScrollBar.this.getBottom() + ViewHelper.getY((View)TouchScrollBar.this.getMe())) {
                                int itemsInWindow = TouchScrollBar.this.recyclerView.getHeight() / TouchScrollBar.this.recyclerView.getChildAt(0).getHeight() * ((GridLayoutManager)TouchScrollBar.this.recyclerView.getLayoutManager()).getSpanCount();
                                int numItemsInList = TouchScrollBar.this.recyclerView.getAdapter().getItemCount();
                                int numScrollableSectionsInList = numItemsInList - itemsInWindow;
                                int[] pos = new int[2];
                                TouchScrollBar.this.getMe().getLocationOnScreen(pos);
                                ((GridLayoutManager)TouchScrollBar.this.recyclerView.getLayoutManager()).scrollToPositionWithOffset((int)((event.getRawY() - (float)pos[1]) / (float)(TouchScrollBar.this.getHeight() - TouchScrollBar.this.handle.getHeight() * 3 / 2) * (float)numScrollableSectionsInList), 0);
                                ViewHelper.setY((View)TouchScrollBar.this.handle, (float)(event.getRawY() - ViewHelper.getY((View)TouchScrollBar.this.getMe()) - (float)(TouchScrollBar.this.handle.getHeight() * 3 / 2)));
                                TouchScrollBar.this.scrollListener.calculateScrollProgress(TouchScrollBar.this.recyclerView);
                                if (TouchScrollBar.this.indicator != null && TouchScrollBar.this.indicator.getVisibility() == 0) {
                                    TouchScrollBar.this.indicator.setScroll(event.getRawY() - (float)(TouchScrollBar.this.handle.getHeight() / 2) - (float)Utils.getDP(40, (View)TouchScrollBar.this.getMe()));
                                }
                            }
                        } else {
                            if (event.getRawY() - (float)(TouchScrollBar.this.handle.getHeight() * 3 / 2) >= ViewHelper.getY((View)TouchScrollBar.this.getMe()) && event.getRawY() - (float)(TouchScrollBar.this.handle.getHeight() / 2) <= (float)TouchScrollBar.this.getBottom() + ViewHelper.getY((View)TouchScrollBar.this.getMe())) {
                                TouchScrollBar.this.recyclerView.scrollToPosition((int)((float)TouchScrollBar.this.recyclerView.getAdapter().getItemCount() * ((event.getRawY() - ViewHelper.getY((View)TouchScrollBar.this.getMe()) - (float)(TouchScrollBar.this.handle.getHeight() * 3 / 2)) / (float)(TouchScrollBar.this.getHeight() - TouchScrollBar.this.handle.getHeight()))));
                                ViewHelper.setY((View)TouchScrollBar.this.handle, (float)(event.getRawY() - ViewHelper.getY((View)TouchScrollBar.this.getMe()) - (float)(TouchScrollBar.this.handle.getHeight() * 3 / 2)));
                                TouchScrollBar.this.scrollListener.calculateScrollProgress(TouchScrollBar.this.recyclerView);
                                if (TouchScrollBar.this.indicator != null && TouchScrollBar.this.indicator.getVisibility() == 0) {
                                    TouchScrollBar.this.indicator.setScroll(event.getRawY() - (float)(TouchScrollBar.this.handle.getHeight() / 2) - (float)Utils.getDP(40, (View)TouchScrollBar.this.getMe()));
                                }
                            }
                            TouchScrollBar.this.recyclerView.onScrolled(0, 0);
                            if (TouchScrollBar.this.indicator != null && TouchScrollBar.this.indicator.getVisibility() == 4) {
                                TouchScrollBar.this.indicator.setVisibility(0);
                                int[] pos = new int[2];
                                TouchScrollBar.this.getMe().getLocationOnScreen(pos);
                                TouchScrollBar.this.indicator.setScroll(TouchScrollBar.this.scrollListener.calculateScrollProgress(TouchScrollBar.this.recyclerView) * (float)(TouchScrollBar.this.getHeight() - TouchScrollBar.this.handle.getHeight()) + (float)pos[1]);
                            }
                        }
                        if (TouchScrollBar.this.lightOnTouch) {
                            TouchScrollBar.this.handle.setBackgroundColor(TouchScrollBar.this.handleColour);
                        }
                        TouchScrollBar.this.mUIHandler.removeCallbacks(TouchScrollBar.this.mFadeBar);
                        TouchScrollBar.this.fadeIn();
                    } else {
                        TouchScrollBar.this.hold = false;
                        if (TouchScrollBar.this.indicator != null && TouchScrollBar.this.indicator.getVisibility() == 0) {
                            if (Build.VERSION.SDK_INT <= 12) {
                                TouchScrollBar.this.indicator.clearAnimation();
                            }
                            TouchScrollBar.this.indicator.setVisibility(4);
                        }
                        if (TouchScrollBar.this.lightOnTouch) {
                            TouchScrollBar.this.handle.setBackgroundColor(TouchScrollBar.this.handleOffColour);
                        }
                        if (TouchScrollBar.this.hide) {
                            TouchScrollBar.this.mUIHandler.removeCallbacks(TouchScrollBar.this.mFadeBar);
                            TouchScrollBar.this.mUIHandler.postDelayed(TouchScrollBar.this.mFadeBar, (long)TouchScrollBar.this.hideDuration);
                        }
                    }
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    int getMode() {
        return 1;
    }

    @Override
    float getHideRatio() {
        return 1.0f;
    }

    @Override
    void onScroll() {
        this.mUIHandler.removeCallbacks(this.mFadeBar);
        this.mUIHandler.postDelayed(this.mFadeBar, (long)this.hideDuration);
        this.fadeIn();
    }

    @Override
    boolean getHide() {
        return this.hide;
    }

    public MaterialScrollBar setAutoHide(Boolean hide) {
        if (!hide.booleanValue()) {
            TranslateAnimation anim = new TranslateAnimation(2, 0.0f, 1, 0.0f, 2, 0.0f, 2, 0.0f);
            anim.setFillAfter(true);
            this.startAnimation((Animation)anim);
        }
        this.hide = hide;
        return this;
    }
}

