/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.RelativeLayout;
import com.nineoldandroids.view.ViewHelper;
import com.turingtechnologies.materialscrollbar.Handle;
import com.turingtechnologies.materialscrollbar.Indicator;
import com.turingtechnologies.materialscrollbar.R;
import com.turingtechnologies.materialscrollbar.Utils;

@SuppressLint(value={"ViewConstructor"})
abstract class MaterialScrollBar
extends RelativeLayout {
    private View background;
    Handle handle;
    int handleColour;
    int handleOffColour = Color.parseColor((String)"#9c9c9c");
    Activity a;
    private boolean hidden = true;
    RecyclerView recyclerView;
    Indicator indicator;
    private int textColour = ContextCompat.getColor((Context)this.getContext(), (int)17170443);
    boolean lightOnTouch;
    boolean totallyHidden = false;
    ScrollListener scrollListener;
    boolean hold = false;

    public boolean getHidden() {
        return this.hidden;
    }

    public String getIndicatorText() {
        return (String)this.indicator.textView.getText();
    }

    MaterialScrollBar(Context context, RecyclerView recyclerView, boolean lightOnTouch) {
        super(context);
        if (!this.isInEditMode()) {
            this.a = (Activity)context;
        }
        this.background = new View(context);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(Utils.getDP(12, (View)this), -1);
        lp.addRule(11);
        this.background.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.background.setBackgroundColor(ContextCompat.getColor((Context)context, (int)0x1060000));
        ViewHelper.setAlpha((View)this.background, (float)0.4f);
        this.handle = new Handle(context, this.getMode());
        lp = new RelativeLayout.LayoutParams(Utils.getDP(12, (View)this), Utils.getDP(72, (View)this));
        lp.addRule(11);
        this.handle.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.lightOnTouch = lightOnTouch;
        this.handleColour = Build.VERSION.SDK_INT >= 21 ? this.fetchAccentColour(context) : Color.parseColor((String)"#9c9c9c");
        int colourToSet = lightOnTouch ? Color.parseColor((String)"#9c9c9c") : this.handleColour;
        this.handle.setBackgroundColor(colourToSet);
        this.addView(this.background);
        this.addView(this.handle);
        this.setId(R.id.reservedNamedId);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(Utils.getDP(20, (View)this), -1);
        layoutParams.addRule(7, recyclerView.getId());
        layoutParams.addRule(6, recyclerView.getId());
        layoutParams.addRule(8, recyclerView.getId());
        ((ViewGroup)recyclerView.getParent()).addView((View)this, (ViewGroup.LayoutParams)layoutParams);
        this.scrollListener = new ScrollListener(this);
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.scrollListener);
        this.recyclerView = recyclerView;
        this.setTouchIntercept();
        TranslateAnimation anim = new TranslateAnimation(2, 0.0f, 1, this.getHideRatio(), 2, 0.0f, 2, 0.0f);
        anim.setDuration(0L);
        anim.setFillAfter(true);
        this.hidden = true;
        this.startAnimation((Animation)anim);
    }

    public MaterialScrollBar getMe() {
        return this;
    }

    abstract void setTouchIntercept();

    abstract int getMode();

    abstract float getHideRatio();

    public MaterialScrollBar setHandleColour(String colour) {
        this.handleColour = Color.parseColor((String)colour);
        this.setHandleColour();
        return this;
    }

    public MaterialScrollBar setHandleColour(int colour) {
        this.handleColour = colour;
        this.setHandleColour();
        return this;
    }

    public MaterialScrollBar setHandleColourRes(int colourResId) {
        this.handleColour = ContextCompat.getColor((Context)this.getContext(), (int)colourResId);
        this.setHandleColour();
        return this;
    }

    private void setHandleColour() {
        if (this.indicator != null) {
            ((GradientDrawable)this.indicator.getBackground()).setColor(this.handleColour);
        }
        if (!this.lightOnTouch) {
            this.handle.setBackgroundColor(this.handleColour);
        }
    }

    public MaterialScrollBar setHandleOffColour(String colour) {
        this.handleOffColour = Color.parseColor((String)colour);
        if (this.lightOnTouch) {
            this.handle.setBackgroundColor(this.handleOffColour);
        }
        return this;
    }

    public MaterialScrollBar setHandleOffColour(int colour) {
        this.handleOffColour = colour;
        if (this.lightOnTouch) {
            this.handle.setBackgroundColor(this.handleOffColour);
        }
        return this;
    }

    public MaterialScrollBar setHandleOffColourRes(int colourResId) {
        this.handleOffColour = ContextCompat.getColor((Context)this.getContext(), (int)colourResId);
        if (this.lightOnTouch) {
            this.handle.setBackgroundColor(this.handleOffColour);
        }
        return this;
    }

    public MaterialScrollBar setBarColour(String colour) {
        this.background.setBackgroundColor(Color.parseColor((String)colour));
        return this;
    }

    public MaterialScrollBar setBarColour(int colour) {
        this.background.setBackgroundColor(colour);
        return this;
    }

    public MaterialScrollBar setBarColourRes(int colourResId) {
        this.background.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)colourResId));
        return this;
    }

    public MaterialScrollBar setTextColour(int colour) {
        this.textColour = colour;
        if (this.indicator != null) {
            this.indicator.setTextColour(this.textColour);
        }
        return this;
    }

    public MaterialScrollBar setTextColourRes(int colourResId) {
        this.textColour = ContextCompat.getColor((Context)this.getContext(), (int)colourResId);
        if (this.indicator != null) {
            this.indicator.setTextColour(this.textColour);
        }
        return this;
    }

    public MaterialScrollBar setTextColour(String colour) {
        this.textColour = Color.parseColor((String)colour);
        if (this.indicator != null) {
            this.indicator.setTextColour(this.textColour);
        }
        return this;
    }

    public MaterialScrollBar removeIndicator() {
        this.indicator = null;
        return this;
    }

    public MaterialScrollBar addIndicator(Indicator indicator, boolean addSpace) {
        indicator.testAdapter(this.recyclerView.getAdapter());
        this.indicator = indicator;
        indicator.linkToScrollBar(this, addSpace);
        indicator.setTextColour(this.textColour);
        return this;
    }

    public MaterialScrollBar setBarThickness(int thickness) {
        thickness = Utils.getDP(thickness, (View)this);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.handle.getLayoutParams();
        layoutParams.width = thickness;
        this.handle.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = (RelativeLayout.LayoutParams)this.background.getLayoutParams();
        layoutParams.width = thickness;
        this.background.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.indicator != null) {
            this.indicator.setSizeCustom(thickness);
        }
        return this;
    }

    @TargetApi(value=21)
    private int fetchAccentColour(Context context) {
        TypedValue typedValue = new TypedValue();
        TypedArray a = context.obtainStyledAttributes(typedValue.data, new int[]{16843829});
        int colour = a.getColor(0, 0);
        a.recycle();
        return colour;
    }

    void fadeOut() {
        if (!this.hidden) {
            TranslateAnimation anim = new TranslateAnimation(2, 0.0f, 1, this.getHideRatio(), 2, 0.0f, 2, 0.0f);
            anim.setDuration(150L);
            anim.setFillAfter(true);
            this.hidden = true;
            this.startAnimation((Animation)anim);
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    MaterialScrollBar.this.handle.expandHandle();
                }
            }, anim.getDuration() / 3L);
        }
    }

    void fadeIn() {
        if (this.hidden && this.getHide() && !this.totallyHidden) {
            this.hidden = false;
            TranslateAnimation anim = new TranslateAnimation(1, this.getHideRatio(), 1, 0.0f, 2, 0.0f, 2, 0.0f);
            anim.setDuration(150L);
            anim.setFillAfter(true);
            this.startAnimation((Animation)anim);
            this.handle.collapseHandle();
        }
    }

    public void setScrollBarHidden(boolean hidden) {
        this.totallyHidden = hidden;
        this.fadeOut();
    }

    abstract void onScroll();

    abstract boolean getHide();

    class ScrollListener
    extends RecyclerView.OnScrollListener {
        MaterialScrollBar materialScrollBar;

        ScrollListener(MaterialScrollBar msb) {
            this.materialScrollBar = msb;
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            if (!MaterialScrollBar.this.hold) {
                ViewHelper.setY((View)MaterialScrollBar.this.handle, (float)((float)recyclerView.computeVerticalScrollOffset() / ((float)recyclerView.computeVerticalScrollRange() - (float)recyclerView.computeVerticalScrollExtent()) * (float)(this.materialScrollBar.getHeight() - MaterialScrollBar.this.handle.getHeight())));
                if (MaterialScrollBar.this.indicator != null && MaterialScrollBar.this.indicator.getVisibility() == 0) {
                    MaterialScrollBar.this.indicator.setScroll(this.calculateScrollProgress(recyclerView) * (float)(this.materialScrollBar.getHeight() - MaterialScrollBar.this.handle.getHeight()) + (float)(MaterialScrollBar.this.handle.getHeight() / 2));
                }
            }
        }

        public float calculateScrollProgress(RecyclerView recyclerView) {
            LinearLayoutManager layoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
            int lastFullyVisiblePosition = layoutManager.findLastCompletelyVisibleItemPosition();
            View visibleChild = recyclerView.getChildAt(0);
            if (visibleChild == null) {
                return 0.0f;
            }
            RecyclerView.ViewHolder holder = recyclerView.getChildViewHolder(visibleChild);
            int itemHeight = holder.itemView.getHeight();
            int recyclerHeight = recyclerView.getHeight();
            int itemsInWindow = layoutManager instanceof GridLayoutManager ? recyclerHeight / itemHeight * ((GridLayoutManager)layoutManager).getSpanCount() : recyclerHeight / itemHeight;
            int numItemsInList = recyclerView.getAdapter().getItemCount();
            int numScrollableSectionsInList = numItemsInList - itemsInWindow;
            int indexOfLastFullyVisibleItemInFirstSection = numItemsInList - numScrollableSectionsInList - 1;
            int currentSection = lastFullyVisiblePosition - indexOfLastFullyVisibleItemInFirstSection;
            if (MaterialScrollBar.this.indicator != null && MaterialScrollBar.this.indicator.getVisibility() == 0) {
                MaterialScrollBar.this.indicator.textView.setText((CharSequence)MaterialScrollBar.this.indicator.getTextElement(currentSection, recyclerView.getAdapter()));
            }
            return (float)currentSection / (float)numScrollableSectionsInList;
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            if (newState == 1) {
                MaterialScrollBar.this.onScroll();
            }
        }
    }
}

