/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.nineoldandroids.view.ViewHelper;
import com.turingtechnologies.materialscrollbar.MaterialScrollBar;
import com.turingtechnologies.materialscrollbar.R;
import com.turingtechnologies.materialscrollbar.Utils;

abstract class Indicator
extends RelativeLayout {
    protected TextView textView;
    private Context context;
    private boolean addSpace;

    public Indicator(Context context) {
        super(context);
        this.context = context;
    }

    public void setSizeCustom(int size) {
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.getLayoutParams();
        if (this.addSpace) {
            lp.setMargins(0, 0, size + Utils.getDP(10, (View)this), 0);
        } else {
            lp.setMargins(0, 0, size, 0);
        }
        this.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    void linkToScrollBar(MaterialScrollBar materialScrollBar, boolean addSpace) {
        this.addSpace = addSpace;
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.indicator));
        } else {
            this.setBackgroundDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.indicator));
        }
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(Utils.getDP(this.getIndicatorWidth(), (View)this), Utils.getDP(this.getIndicatorHeight(), (View)this));
        if (addSpace) {
            lp.setMargins(0, 0, Utils.getDP(22, (View)this), 0);
        } else {
            lp.setMargins(0, 0, Utils.getDP(12, (View)this), 0);
        }
        this.setVisibility(4);
        this.textView = new TextView(this.context);
        this.textView.setTextSize(1, (float)this.getTextSize());
        RelativeLayout.LayoutParams tvlp = new RelativeLayout.LayoutParams(-2, -2);
        tvlp.addRule(13, -1);
        this.addView((View)this.textView, (ViewGroup.LayoutParams)tvlp);
        ((GradientDrawable)this.getBackground()).setColor(materialScrollBar.handleColour);
        lp.addRule(7, materialScrollBar.getId());
        ((ViewGroup)materialScrollBar.getParent()).addView((View)this, (ViewGroup.LayoutParams)lp);
    }

    void setScroll(float y) {
        if ((y -= (float)Utils.getDP(this.getIndicatorHeight() + 25, (View)this)) < 0.0f) {
            ViewHelper.setScaleY((View)this, (float)-1.0f);
            ViewHelper.setScaleY((View)this.textView, (float)-1.0f);
            ViewHelper.setY((View)this, (float)(y += (float)Utils.getDP(this.getIndicatorHeight(), (View)this)));
        } else {
            ViewHelper.setScaleY((View)this, (float)1.0f);
            ViewHelper.setScaleY((View)this.textView, (float)1.0f);
            ViewHelper.setY((View)this, (float)y);
        }
    }

    void setTextColour(int colour) {
        this.textView.setTextColor(colour);
    }

    abstract String getTextElement(Integer var1, RecyclerView.Adapter var2);

    abstract int getIndicatorHeight();

    abstract int getIndicatorWidth();

    abstract void testAdapter(RecyclerView.Adapter var1);

    abstract int getTextSize();
}

