/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.content.Context;
import android.os.Build;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import com.nineoldandroids.view.ViewHelper;
import com.turingtechnologies.materialscrollbar.MaterialScrollBar;
import com.turingtechnologies.materialscrollbar.Utils;

public class DragScrollBar
extends MaterialScrollBar {
    public DragScrollBar(Context context, RecyclerView recyclerView, boolean lightOnTouch) {
        super(context, recyclerView, lightOnTouch);
    }

    @Override
    void setTouchIntercept() {
        this.handle.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (!DragScrollBar.this.totallyHidden) {
                    if (event.getAction() != 1) {
                        DragScrollBar.this.hold = true;
                        if (DragScrollBar.this.indicator != null && DragScrollBar.this.indicator.getVisibility() == 4) {
                            DragScrollBar.this.indicator.setVisibility(0);
                            DragScrollBar.this.indicator.setScroll(DragScrollBar.this.scrollListener.calculateScrollProgress(DragScrollBar.this.recyclerView) * (float)(DragScrollBar.this.getHeight() - DragScrollBar.this.handle.getHeight()));
                        }
                        if (DragScrollBar.this.recyclerView.getLayoutManager() instanceof GridLayoutManager && ((GridLayoutManager)DragScrollBar.this.recyclerView.getLayoutManager()).getSpanCount() != 1) {
                            if (event.getRawY() - (float)(DragScrollBar.this.handle.getHeight() * 3 / 2) >= ViewHelper.getY((View)DragScrollBar.this.getMe()) && event.getRawY() - (float)(DragScrollBar.this.handle.getHeight() / 2) <= (float)DragScrollBar.this.getBottom() + ViewHelper.getY((View)DragScrollBar.this.getMe())) {
                                int itemsInWindow = DragScrollBar.this.recyclerView.getHeight() / DragScrollBar.this.recyclerView.getChildAt(0).getHeight() * ((GridLayoutManager)DragScrollBar.this.recyclerView.getLayoutManager()).getSpanCount();
                                int numItemsInList = DragScrollBar.this.recyclerView.getAdapter().getItemCount();
                                int numScrollableSectionsInList = numItemsInList - itemsInWindow;
                                int[] pos = new int[2];
                                DragScrollBar.this.getMe().getLocationOnScreen(pos);
                                ((GridLayoutManager)DragScrollBar.this.recyclerView.getLayoutManager()).scrollToPositionWithOffset((int)((event.getRawY() - (float)pos[1]) / (float)(DragScrollBar.this.getHeight() - DragScrollBar.this.handle.getHeight() * 3 / 2) * (float)numScrollableSectionsInList), 0);
                                ViewHelper.setY((View)DragScrollBar.this.handle, (float)(event.getRawY() - ViewHelper.getY((View)DragScrollBar.this.getMe()) - (float)(DragScrollBar.this.handle.getHeight() * 3 / 2)));
                                DragScrollBar.this.scrollListener.calculateScrollProgress(DragScrollBar.this.recyclerView);
                                if (DragScrollBar.this.indicator != null && DragScrollBar.this.indicator.getVisibility() == 0) {
                                    DragScrollBar.this.indicator.setScroll(event.getRawY() - (float)(DragScrollBar.this.handle.getHeight() / 2) - (float)Utils.getDP(40, (View)DragScrollBar.this.getMe()));
                                }
                            }
                        } else if (event.getRawY() - (float)(DragScrollBar.this.handle.getHeight() * 3 / 2) >= ViewHelper.getY((View)DragScrollBar.this.getMe()) && event.getRawY() - (float)(DragScrollBar.this.handle.getHeight() / 2) <= (float)DragScrollBar.this.getBottom() + ViewHelper.getY((View)DragScrollBar.this.getMe())) {
                            DragScrollBar.this.recyclerView.scrollToPosition((int)((float)DragScrollBar.this.recyclerView.getAdapter().getItemCount() * ((event.getRawY() - ViewHelper.getY((View)DragScrollBar.this.getMe()) - (float)(DragScrollBar.this.handle.getHeight() * 3 / 2)) / (float)(DragScrollBar.this.getHeight() - DragScrollBar.this.handle.getHeight()))));
                            ViewHelper.setY((View)DragScrollBar.this.handle, (float)(event.getRawY() - ViewHelper.getY((View)DragScrollBar.this.getMe()) - (float)(DragScrollBar.this.handle.getHeight() * 3 / 2)));
                            DragScrollBar.this.scrollListener.calculateScrollProgress(DragScrollBar.this.recyclerView);
                            if (DragScrollBar.this.indicator != null && DragScrollBar.this.indicator.getVisibility() == 0) {
                                DragScrollBar.this.indicator.setScroll(event.getRawY() - (float)(DragScrollBar.this.handle.getHeight() / 2) - (float)Utils.getDP(40, (View)DragScrollBar.this.getMe()));
                            }
                        }
                        DragScrollBar.this.recyclerView.onScrolled(0, 0);
                        if (DragScrollBar.this.lightOnTouch) {
                            DragScrollBar.this.handle.setBackgroundColor(DragScrollBar.this.handleColour);
                        }
                        DragScrollBar.this.fadeIn();
                    } else {
                        DragScrollBar.this.hold = false;
                        if (DragScrollBar.this.indicator != null && DragScrollBar.this.indicator.getVisibility() == 0) {
                            if (Build.VERSION.SDK_INT <= 12) {
                                DragScrollBar.this.indicator.clearAnimation();
                            }
                            DragScrollBar.this.indicator.setVisibility(4);
                        }
                        if (DragScrollBar.this.lightOnTouch) {
                            DragScrollBar.this.handle.setBackgroundColor(DragScrollBar.this.handleOffColour);
                        }
                        DragScrollBar.this.fadeOut();
                    }
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    int getMode() {
        return 0;
    }

    @Override
    float getHideRatio() {
        return 0.35f;
    }

    @Override
    void onScroll() {
    }

    @Override
    boolean getHide() {
        return true;
    }
}

