/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.turingtechnologies.materialscrollbar.Handle;
import com.turingtechnologies.materialscrollbar.ICustomScroller;
import com.turingtechnologies.materialscrollbar.Indicator;
import com.turingtechnologies.materialscrollbar.R;
import com.turingtechnologies.materialscrollbar.ScrollingUtilities;
import com.turingtechnologies.materialscrollbar.Utils;
import java.util.ArrayList;

public abstract class MaterialScrollBar<T>
extends RelativeLayout {
    private View handleTrack;
    Handle handleThumb;
    Indicator indicator;
    int handleColor;
    int handleOffColor = Color.parseColor((String)"#9c9c9c");
    protected boolean hidden = true;
    private int textColor = ContextCompat.getColor((Context)this.getContext(), (int)17170443);
    private boolean lightOnTouch;
    private TypedArray a;
    private Boolean rtl = false;
    boolean hiddenByUser = false;
    private boolean hiddenByNotEnoughElements = false;
    private float fastScrollSnapPercent = 0.0f;
    private Boolean isDragging = false;
    RecyclerView recyclerView;
    private int seekId = 0;
    ScrollingUtilities scrollUtils = new ScrollingUtilities(this);
    SwipeRefreshLayout swipeRefreshLayout;
    private ArrayList<RecyclerView.OnScrollListener> listeners = new ArrayList();
    private View.OnLayoutChangeListener indicatorLayoutListener;
    private float previousScrollPercent = 0.0f;
    Boolean draggableFromAnywhere = false;
    ArrayList<Runnable> onAttach = new ArrayList();
    private boolean attached = false;
    ScrollMode scrollMode;
    float currentScrollPercent = 0.0f;

    MaterialScrollBar(Context context, RecyclerView recyclerView, boolean lightOnTouch) {
        super(context);
        this.recyclerView = recyclerView;
        this.setRightToLeft(Utils.isRightToLeft(context));
        this.addView(this.setUpHandleTrack(context));
        this.addView(this.setUpHandle(context, lightOnTouch));
        this.generalSetup();
    }

    MaterialScrollBar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    MaterialScrollBar(Context context, AttributeSet attributeSet, int defStyle) {
        super(context, attributeSet, defStyle);
        this.setRightToLeft(Utils.isRightToLeft(context));
        this.setUpProps(context, attributeSet);
        this.addView(this.setUpHandleTrack(context));
        this.addView(this.setUpHandle(context, this.a.getBoolean(R.styleable.MaterialScrollBar_msb_lightOnTouch, true)));
    }

    void setUpProps(Context context, AttributeSet attributes) {
        this.a = context.getTheme().obtainStyledAttributes(attributes, R.styleable.MaterialScrollBar, 0, 0);
        if (!this.a.hasValue(R.styleable.MaterialScrollBar_msb_lightOnTouch)) {
            throw new IllegalStateException("You are missing the following required attributes from a scroll bar in your XML: lightOnTouch");
        }
        if (!this.isInEditMode()) {
            this.seekId = this.a.getResourceId(R.styleable.MaterialScrollBar_msb_recyclerView, 0);
        }
        this.scrollMode = this.a.getInt(R.styleable.MaterialScrollBar_msb_scrollMode, 0) == 0 ? ScrollMode.FIRST_VISIBLE : ScrollMode.LAST_ELEMENT;
    }

    View setUpHandleTrack(Context context) {
        this.handleTrack = new View(context);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(Utils.getDP(14, (View)this), -1);
        lp.addRule(this.rtl != false ? 9 : 11);
        this.handleTrack.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.handleTrack.setBackgroundColor(ContextCompat.getColor((Context)context, (int)0x1060000));
        this.handleTrack.setAlpha(0.4f);
        return this.handleTrack;
    }

    Handle setUpHandle(Context context, Boolean lightOnTouch) {
        this.handleThumb = new Handle(context, this.getMode());
        this.handleThumb.rtl = this.rtl;
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(Utils.getDP(18, (View)this), Utils.getDP(72, (View)this));
        lp.addRule(this.rtl != false ? 9 : 11);
        this.handleThumb.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.lightOnTouch = lightOnTouch;
        this.handleColor = MaterialScrollBar.fetchAccentColor(context);
        int colorToSet = lightOnTouch != false ? Color.parseColor((String)"#9c9c9c") : this.handleColor;
        this.handleThumb.setBackgroundColor(colorToSet);
        return this.handleThumb;
    }

    void implementPreferences() {
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_barColor)) {
            this.setBarColor(this.a.getColor(R.styleable.MaterialScrollBar_msb_barColor, 0));
        }
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_handleColor)) {
            this.setHandleColor(this.a.getColor(R.styleable.MaterialScrollBar_msb_handleColor, 0));
        }
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_handleOffColor)) {
            this.setHandleOffColor(this.a.getColor(R.styleable.MaterialScrollBar_msb_handleOffColor, 0));
        }
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_textColor)) {
            this.setTextColor(this.a.getColor(R.styleable.MaterialScrollBar_msb_textColor, 0));
        }
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_barThickness)) {
            this.setBarThickness(this.a.getDimensionPixelSize(R.styleable.MaterialScrollBar_msb_barThickness, 0));
        }
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_rightToLeft)) {
            this.setRightToLeft(this.a.getBoolean(R.styleable.MaterialScrollBar_msb_rightToLeft, false));
        }
    }

    public T setRecyclerView(RecyclerView rv) {
        if (this.seekId != 0) {
            throw new IllegalStateException("There is already a recyclerView set by XML.");
        }
        if (this.recyclerView != null) {
            throw new IllegalStateException("There is already a recyclerView set.");
        }
        this.recyclerView = rv;
        this.generalSetup();
        return (T)((Object)this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.attached = true;
        if (this.seekId != 0) {
            try {
                this.recyclerView = (RecyclerView)Utils.findNearestNeighborWithID(this.seekId, (View)this);
                if (this.recyclerView == null) {
                    throw new RuntimeException("The id given for the recyclerView did not refer to a sibling of the bar or one of its ascendants");
                }
            }
            catch (ClassCastException e) {
                throw new RuntimeException("The id given for the recyclerView did not refer to a RecyclerView", e);
            }
            this.implementPreferences();
            this.implementFlavourPreferences();
            this.a.recycle();
            this.generalSetup();
        }
    }

    private void generalSetup() {
        this.recyclerView.setVerticalScrollBarEnabled(false);
        this.recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new ScrollListener());
        this.setTouchIntercept();
        this.identifySwipeRefreshParents();
        this.checkCustomScrolling();
        for (int i = 0; i < this.onAttach.size(); ++i) {
            this.onAttach.get(i).run();
        }
        TranslateAnimation anim = new TranslateAnimation(2, 0.0f, 1, this.rtl != false ? -this.getHideRatio() : this.getHideRatio(), 2, 0.0f, 2, 0.0f);
        anim.setDuration(0L);
        anim.setFillAfter(true);
        this.hidden = true;
        this.startAnimation((Animation)anim);
    }

    void identifySwipeRefreshParents() {
        boolean cycle = true;
        ViewParent parent = this.getParent();
        if (parent != null) {
            while (cycle) {
                if (parent instanceof SwipeRefreshLayout) {
                    this.swipeRefreshLayout = (SwipeRefreshLayout)parent;
                    cycle = false;
                    continue;
                }
                if (parent.getParent() == null) {
                    cycle = false;
                    continue;
                }
                parent = parent.getParent();
            }
        }
    }

    boolean isScrollChangeLargeEnoughForFastScroll(float currentScrollPercent) {
        return Math.abs(currentScrollPercent - this.previousScrollPercent) > this.fastScrollSnapPercent;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.recyclerView == null && !this.isInEditMode()) {
            throw new RuntimeException("You need to set a recyclerView for the scroll bar, either in the XML or using setRecyclerView().");
        }
        if (this.recyclerView.getLayoutManager() == null && !this.isInEditMode()) {
            return;
        }
        this.scrollUtils.scrollHandleAndIndicator();
        if (!this.isInEditMode()) {
            this.scrollUtils.scrollHandleAndIndicator();
            this.hiddenByNotEnoughElements = this.scrollUtils.getAvailableScrollHeight() <= 0;
            if (this.hiddenByNotEnoughElements) {
                this.handleTrack.setVisibility(8);
                this.handleThumb.setVisibility(8);
            } else {
                this.handleTrack.setVisibility(0);
                this.handleThumb.setVisibility(0);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredWidth = Utils.getDP(18, (View)this);
        int desiredHeight = 100;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth);
        int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(desiredHeight, heightSize) : desiredHeight);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    abstract void setTouchIntercept();

    abstract int getMode();

    abstract float getHideRatio();

    abstract void onScroll();

    abstract boolean getHide();

    abstract void implementFlavourPreferences();

    abstract float getHandleOffset();

    abstract float getIndicatorOffset();

    private void checkCustomScrollingInterface() {
        if (this.recyclerView.getAdapter() instanceof ICustomScroller) {
            this.scrollUtils.customScroller = (ICustomScroller)this.recyclerView.getAdapter();
        }
    }

    public T setFastScrollSnapPercent(float snapPercent) {
        this.fastScrollSnapPercent = snapPercent;
        return (T)((Object)this);
    }

    private void checkCustomScrolling() {
        if (ViewCompat.isAttachedToWindow((View)this)) {
            this.checkCustomScrollingInterface();
        } else {
            this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    MaterialScrollBar.this.removeOnLayoutChangeListener(this);
                    MaterialScrollBar.this.checkCustomScrollingInterface();
                }
            });
        }
    }

    public T setHandleColor(String color2) {
        this.handleColor = Color.parseColor((String)color2);
        this.setHandleColor();
        return (T)((Object)this);
    }

    public T setHandleColor(@ColorInt int color2) {
        this.handleColor = color2;
        this.setHandleColor();
        return (T)((Object)this);
    }

    public T setHandleColorRes(@ColorRes int colorResId) {
        this.handleColor = ContextCompat.getColor((Context)this.getContext(), (int)colorResId);
        this.setHandleColor();
        return (T)((Object)this);
    }

    private void setHandleColor() {
        if (this.indicator != null) {
            ((GradientDrawable)this.indicator.getBackground()).setColor(this.handleColor);
        }
        if (!this.lightOnTouch) {
            this.handleThumb.setBackgroundColor(this.handleColor);
        }
    }

    public T setHandleOffColor(String color2) {
        this.handleOffColor = Color.parseColor((String)color2);
        if (this.lightOnTouch) {
            this.handleThumb.setBackgroundColor(this.handleOffColor);
        }
        return (T)((Object)this);
    }

    public T setHandleOffColor(@ColorInt int color2) {
        this.handleOffColor = color2;
        if (this.lightOnTouch) {
            this.handleThumb.setBackgroundColor(this.handleOffColor);
        }
        return (T)((Object)this);
    }

    public T setHandleOffColorRes(@ColorRes int colorResId) {
        this.handleOffColor = ContextCompat.getColor((Context)this.getContext(), (int)colorResId);
        if (this.lightOnTouch) {
            this.handleThumb.setBackgroundColor(this.handleOffColor);
        }
        return (T)((Object)this);
    }

    public T setBarColor(String color2) {
        this.handleTrack.setBackgroundColor(Color.parseColor((String)color2));
        return (T)((Object)this);
    }

    public T setBarColor(@ColorInt int color2) {
        this.handleTrack.setBackgroundColor(color2);
        return (T)((Object)this);
    }

    public T setBarColorRes(@ColorRes int colorResId) {
        this.handleTrack.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)colorResId));
        return (T)((Object)this);
    }

    public T setTextColor(@ColorInt int color2) {
        this.textColor = color2;
        if (this.indicator != null) {
            this.indicator.setTextColor(this.textColor);
        }
        return (T)((Object)this);
    }

    public T setTextColorRes(@ColorRes int colorResId) {
        this.textColor = ContextCompat.getColor((Context)this.getContext(), (int)colorResId);
        if (this.indicator != null) {
            this.indicator.setTextColor(this.textColor);
        }
        return (T)((Object)this);
    }

    public T setTextColor(String color2) {
        this.textColor = Color.parseColor((String)color2);
        if (this.indicator != null) {
            this.indicator.setTextColor(this.textColor);
        }
        return (T)((Object)this);
    }

    public T removeIndicator() {
        if (this.indicator != null) {
            this.indicator.removeAllViews();
        }
        this.indicator = null;
        return (T)((Object)this);
    }

    public T setIndicator(Indicator indicator, boolean addSpaceSide) {
        if (ViewCompat.isAttachedToWindow((View)this)) {
            this.setupIndicator(indicator, addSpaceSide);
        } else {
            this.removeOnLayoutChangeListener(this.indicatorLayoutListener);
            this.indicatorLayoutListener = (a, b, c, d, e, f, g, h, i) -> {
                this.setupIndicator(indicator, addSpaceSide);
                this.removeOnLayoutChangeListener(this.indicatorLayoutListener);
            };
            this.addOnLayoutChangeListener(this.indicatorLayoutListener);
        }
        return (T)((Object)this);
    }

    private void setupIndicator(Indicator indicator, boolean addSpaceSide) {
        this.indicator = indicator;
        indicator.testAdapter(this.recyclerView.getAdapter());
        indicator.setRTL(this.rtl);
        indicator.linkToScrollBar(this, addSpaceSide);
        indicator.setTextColor(this.textColor);
    }

    public T setBarThickness(int thickness) {
        if (!this.attached) {
            this.onAttach.add(() -> this.setBarThickness(thickness));
            return (T)((Object)this);
        }
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.handleThumb.getLayoutParams();
        layoutParams.width = thickness;
        this.handleThumb.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = (RelativeLayout.LayoutParams)this.handleTrack.getLayoutParams();
        layoutParams.width = thickness;
        this.handleTrack.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.indicator != null) {
            this.indicator.setSizeCustom(thickness);
        }
        layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        layoutParams.width = thickness;
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return (T)((Object)this);
    }

    public void setScrollBarHidden(boolean hidden) {
        this.hiddenByUser = hidden;
        if (this.hiddenByUser) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
        }
    }

    public void setRightToLeft(boolean rtl) {
        this.rtl = rtl;
        if (this.handleThumb != null) {
            this.handleThumb.setRightToLeft(rtl);
        }
        if (this.indicator != null) {
            this.indicator.setRTL(rtl);
            this.indicator.setLayoutParams((ViewGroup.LayoutParams)this.indicator.refreshMargins((RelativeLayout.LayoutParams)this.indicator.getLayoutParams()));
        }
    }

    public void setDraggableFromAnywhere(boolean draggableFromAnywhere) {
        this.draggableFromAnywhere = draggableFromAnywhere;
    }

    public void addScrollListener(RecyclerView.OnScrollListener scrollListener) {
        this.listeners.add(scrollListener);
    }

    public void removeScrollListener(RecyclerView.OnScrollListener scrollListener) {
        this.listeners.remove(scrollListener);
    }

    public void clearScrollListeners() {
        this.listeners.clear();
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    static int fetchAccentColor(Context context) {
        TypedValue typedValue = new TypedValue();
        TypedArray a = context.obtainStyledAttributes(typedValue.data, new int[]{R.attr.colorAccent});
        int color2 = a.getColor(0, 0);
        a.recycle();
        return color2;
    }

    void fadeOut() {
        if (!this.hidden) {
            TranslateAnimation anim = new TranslateAnimation(2, 0.0f, 1, this.rtl != false ? -this.getHideRatio() : this.getHideRatio(), 2, 0.0f, 2, 0.0f);
            anim.setDuration(150L);
            anim.setFillAfter(true);
            this.hidden = true;
            this.startAnimation((Animation)anim);
            this.postDelayed(() -> this.handleThumb.expandHandle(), anim.getDuration() / 3L);
        }
    }

    void fadeIn() {
        if (this.hidden && this.getHide() && !this.hiddenByUser) {
            this.hidden = false;
            TranslateAnimation anim = new TranslateAnimation(1, this.rtl != false ? -this.getHideRatio() : this.getHideRatio(), 1, 0.0f, 2, 0.0f, 2, 0.0f);
            anim.setDuration(150L);
            anim.setFillAfter(true);
            this.startAnimation((Animation)anim);
            this.handleThumb.collapseHandle();
        }
    }

    protected void onDown(MotionEvent event) {
        if (this.indicator != null && this.indicator.getVisibility() == 4 && this.recyclerView.getAdapter() != null && !this.hiddenByNotEnoughElements) {
            this.indicator.setVisibility(0);
            this.indicator.setAlpha(0.0f);
            this.indicator.animate().alpha(1.0f).setDuration(150L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                @TargetApi(value=11)
                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    MaterialScrollBar.this.indicator.setAlpha(1.0f);
                }
            });
        }
        int top = this.handleThumb.getHeight() / 2;
        int bottom = this.recyclerView.getHeight() - Utils.getDP(72, this.recyclerView.getContext());
        float boundedY = Math.max((float)top, Math.min((float)bottom, event.getY() - this.getHandleOffset()));
        this.currentScrollPercent = (boundedY - (float)top) / (float)(bottom - top);
        if (this.isScrollChangeLargeEnoughForFastScroll(this.currentScrollPercent) || this.currentScrollPercent == 0.0f || this.currentScrollPercent == 1.0f) {
            this.previousScrollPercent = this.currentScrollPercent;
            int dy = this.scrollUtils.scrollToPositionAtProgress(this.currentScrollPercent);
            this.scrollUtils.scrollHandleAndIndicator();
            if (dy != 0) {
                for (RecyclerView.OnScrollListener listener : this.listeners) {
                    listener.onScrolled(this.recyclerView, 0, dy);
                }
            }
        }
        if (this.lightOnTouch) {
            this.handleThumb.setBackgroundColor(this.handleColor);
        }
        this.isDragging = true;
    }

    protected void onUp() {
        if (this.indicator != null && this.indicator.getVisibility() == 0) {
            this.indicator.animate().alpha(0.0f).setDuration(150L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    MaterialScrollBar.this.indicator.setVisibility(4);
                }
            });
        }
        if (this.lightOnTouch) {
            this.handleThumb.setBackgroundColor(this.handleOffColor);
        }
        this.isDragging = false;
    }

    protected boolean validTouch(MotionEvent event) {
        return this.draggableFromAnywhere != false || event.getY() >= this.handleThumb.getY() - (float)Utils.getDP(20, this.recyclerView.getContext()) && event.getY() <= this.handleThumb.getY() + (float)this.handleThumb.getHeight();
    }

    static enum ScrollMode {
        FIRST_VISIBLE,
        LAST_ELEMENT;

    }

    class ScrollListener
    extends RecyclerView.OnScrollListener {
        ScrollListener() {
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            MaterialScrollBar.this.scrollUtils.scrollHandleAndIndicator();
            if (dy != 0) {
                MaterialScrollBar.this.onScroll();
            }
            if (MaterialScrollBar.this.swipeRefreshLayout != null && !MaterialScrollBar.this.swipeRefreshLayout.isRefreshing()) {
                MaterialScrollBar.this.swipeRefreshLayout.setEnabled(((LinearLayoutManager)recyclerView.getLayoutManager()).findFirstCompletelyVisibleItemPosition() == 0);
            }
        }
    }
}

