/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import androidx.recyclerview.widget.RecyclerView;
import com.turingtechnologies.materialscrollbar.MaterialScrollBar;
import com.turingtechnologies.materialscrollbar.R;

public class TouchScrollBar
extends MaterialScrollBar<TouchScrollBar> {
    private boolean hide = true;
    private int hideDuration = 2500;
    private Handler uiHandler = new Handler(Looper.getMainLooper());
    private boolean respondToTouch = true;
    private TypedArray flavourAttributes;
    private Runnable fadeBar = this::fadeOut;

    public TouchScrollBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public TouchScrollBar(Context context, AttributeSet attributeSet, int defStyle) {
        super(context, attributeSet, defStyle);
    }

    public TouchScrollBar(Context context, RecyclerView recyclerView, boolean lightOnTouch) {
        super(context, recyclerView, lightOnTouch);
    }

    public TouchScrollBar setHideDuration(int duration) {
        this.hideDuration = duration;
        return this;
    }

    @Override
    void setUpProps(Context context, AttributeSet attributes) {
        super.setUpProps(context, attributes);
        this.flavourAttributes = context.getTheme().obtainStyledAttributes(attributes, R.styleable.TouchScrollBar, 0, 0);
    }

    @Override
    void setTouchIntercept() {
        this.setOnTouchListener((v, event) -> {
            if (!this.hiddenByUser) {
                boolean valid = this.validTouch(event);
                if (event.getAction() == 0 && !valid) {
                    return false;
                }
                if (event.getAction() != 1) {
                    if (!this.hidden || this.respondToTouch) {
                        this.onDown(event);
                        if (this.hide) {
                            this.uiHandler.removeCallbacks(this.fadeBar);
                            this.fadeIn();
                        }
                    }
                } else {
                    this.onUp();
                    if (this.hide) {
                        this.uiHandler.removeCallbacks(this.fadeBar);
                        this.uiHandler.postDelayed(this.fadeBar, (long)this.hideDuration);
                    }
                }
                this.performClick();
                return true;
            }
            return false;
        });
    }

    @Override
    int getMode() {
        return 1;
    }

    @Override
    float getHideRatio() {
        return 1.0f;
    }

    @Override
    void onScroll() {
        if (this.hide) {
            this.uiHandler.removeCallbacks(this.fadeBar);
            this.uiHandler.postDelayed(this.fadeBar, (long)this.hideDuration);
            this.fadeIn();
        }
    }

    @Override
    boolean getHide() {
        return true;
    }

    @Override
    void implementFlavourPreferences() {
        if (this.flavourAttributes.hasValue(R.styleable.TouchScrollBar_msb_autoHide)) {
            this.setAutoHide(this.flavourAttributes.getBoolean(R.styleable.TouchScrollBar_msb_autoHide, true));
        }
        if (this.flavourAttributes.hasValue(R.styleable.TouchScrollBar_msb_hideDelayInMilliseconds)) {
            this.hideDuration = this.flavourAttributes.getInteger(R.styleable.TouchScrollBar_msb_hideDelayInMilliseconds, 2500);
        }
    }

    @Override
    float getHandleOffset() {
        return 0.0f;
    }

    @Override
    float getIndicatorOffset() {
        return 0.0f;
    }

    public TouchScrollBar setAutoHide(Boolean hide) {
        if (!hide.booleanValue()) {
            TranslateAnimation anim = new TranslateAnimation(2, 0.0f, 1, 0.0f, 2, 0.0f, 2, 0.0f);
            anim.setFillAfter(true);
            this.startAnimation((Animation)anim);
        }
        this.hide = hide;
        return this;
    }

    public TouchScrollBar setRespondToTouchIfHidden(boolean respondToTouchIfHidden) {
        this.respondToTouch = respondToTouchIfHidden;
        return this;
    }
}

