/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import com.turingtechnologies.materialscrollbar.ICustomScroller;
import com.turingtechnologies.materialscrollbar.MaterialScrollBar;

class ScrollingUtilities {
    private MaterialScrollBar materialScrollBar;
    ICustomScroller customScroller;
    private ScrollPositionState scrollPosState = new ScrollPositionState();
    private int constant;
    private LinearLayoutManager layoutManager;

    ScrollingUtilities(MaterialScrollBar msb) {
        this.materialScrollBar = msb;
    }

    void scrollHandleAndIndicator() {
        this.getCurScrollState();
        this.constant = this.customScroller != null ? this.customScroller.getDepthForItem(this.materialScrollBar.recyclerView.getChildAdapterPosition(this.materialScrollBar.recyclerView.getChildAt(0))) : this.scrollPosState.rowHeight * this.scrollPosState.rowIndex;
        this.constant += this.materialScrollBar.recyclerView.getPaddingTop();
        int scrollBarY = (int)this.getScrollPosition();
        this.materialScrollBar.handleThumb.setY(scrollBarY);
        this.materialScrollBar.handleThumb.invalidate();
        if (this.materialScrollBar.indicator != null) {
            int element = this.materialScrollBar.recyclerView.getLayoutManager() instanceof GridLayoutManager ? this.scrollPosState.rowIndex * ((GridLayoutManager)this.materialScrollBar.recyclerView.getLayoutManager()).getSpanCount() : this.scrollPosState.indicatorPosition;
            this.materialScrollBar.indicator.setText(element);
            this.materialScrollBar.indicator.setScroll(scrollBarY + this.materialScrollBar.getTop());
        }
    }

    private float getScrollPosition() {
        this.getCurScrollState();
        int scrollY = this.materialScrollBar.getPaddingTop() + this.constant - this.scrollPosState.rowTopOffset;
        int scrollHeight = this.getAvailableScrollHeight();
        int barHeight = this.getAvailableScrollBarHeight();
        return (float)scrollY / (float)scrollHeight * (float)barHeight;
    }

    private int getRowCount() {
        int rowCount = this.materialScrollBar.recyclerView.getLayoutManager().getItemCount();
        if (this.materialScrollBar.recyclerView.getLayoutManager() instanceof GridLayoutManager) {
            int spanCount = ((GridLayoutManager)this.materialScrollBar.recyclerView.getLayoutManager()).getSpanCount();
            rowCount = (int)Math.ceil((double)rowCount / (double)spanCount);
        }
        return rowCount;
    }

    int getAvailableScrollBarHeight() {
        return this.materialScrollBar.getHeight() - this.materialScrollBar.handleThumb.getHeight();
    }

    int scrollToPositionAtProgress(float touchFraction) {
        int exactItemPos;
        int priorPosition = this.materialScrollBar.recyclerView.computeVerticalScrollOffset();
        if (this.customScroller == null) {
            int spanCount = 1;
            if (this.materialScrollBar.recyclerView.getLayoutManager() instanceof GridLayoutManager) {
                spanCount = ((GridLayoutManager)this.materialScrollBar.recyclerView.getLayoutManager()).getSpanCount();
            }
            this.materialScrollBar.recyclerView.stopScroll();
            this.getCurScrollState();
            exactItemPos = (int)((float)this.getAvailableScrollHeight() * touchFraction);
            LinearLayoutManager layoutManager = (LinearLayoutManager)this.materialScrollBar.recyclerView.getLayoutManager();
            try {
                layoutManager.scrollToPositionWithOffset(spanCount * exactItemPos / this.scrollPosState.rowHeight, -(exactItemPos % this.scrollPosState.rowHeight));
            }
            catch (ArithmeticException arithmeticException) {}
        } else {
            if (this.layoutManager == null) {
                this.layoutManager = (LinearLayoutManager)this.materialScrollBar.recyclerView.getLayoutManager();
            }
            int exactItemPos2 = this.customScroller.getItemIndexForScroll(touchFraction);
            int offset = (int)((float)this.customScroller.getDepthForItem(exactItemPos2) - touchFraction * (float)this.getAvailableScrollHeight());
            this.layoutManager.scrollToPositionWithOffset(exactItemPos2, offset);
            return 0;
        }
        return exactItemPos - priorPosition;
    }

    int getAvailableScrollHeight() {
        int visibleHeight = this.materialScrollBar.recyclerView.getHeight();
        int scrollHeight = this.customScroller != null ? this.materialScrollBar.recyclerView.getPaddingTop() + this.customScroller.getTotalDepth() + this.materialScrollBar.recyclerView.getPaddingBottom() : this.materialScrollBar.recyclerView.getPaddingTop() + this.getRowCount() * this.scrollPosState.rowHeight + this.materialScrollBar.recyclerView.getPaddingBottom();
        return scrollHeight - visibleHeight;
    }

    void getCurScrollState() {
        this.scrollPosState.rowIndex = -1;
        this.scrollPosState.rowTopOffset = -1;
        this.scrollPosState.rowHeight = -1;
        if (this.materialScrollBar.recyclerView.getAdapter() == null) {
            Log.e((String)"MaterialScrollBarLib", (String)"The adapter for your recyclerView has not been set; skipping layout.");
            return;
        }
        int itemCount = this.materialScrollBar.recyclerView.getAdapter().getItemCount();
        if (itemCount == 0) {
            return;
        }
        View child = this.materialScrollBar.recyclerView.getChildAt(0);
        this.scrollPosState.rowIndex = this.materialScrollBar.recyclerView.getChildAdapterPosition(child);
        this.scrollPosState.indicatorPosition = this.getIndicatorPosition();
        if (this.materialScrollBar.recyclerView.getLayoutManager() instanceof GridLayoutManager) {
            this.scrollPosState.rowIndex = this.scrollPosState.rowIndex / ((GridLayoutManager)this.materialScrollBar.recyclerView.getLayoutManager()).getSpanCount();
        }
        if (child == null) {
            this.scrollPosState.rowTopOffset = 0;
            this.scrollPosState.rowHeight = 0;
        } else {
            this.scrollPosState.rowTopOffset = this.materialScrollBar.recyclerView.getLayoutManager().getDecoratedTop(child);
            this.scrollPosState.rowHeight = child.getHeight();
            if (child.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                this.scrollPosState.rowHeight += ((ViewGroup.MarginLayoutParams)child.getLayoutParams()).topMargin;
                this.scrollPosState.rowHeight += ((ViewGroup.MarginLayoutParams)child.getLayoutParams()).bottomMargin;
            }
        }
    }

    private int getIndicatorPosition() {
        if (this.materialScrollBar.scrollMode == MaterialScrollBar.ScrollMode.FIRST_VISIBLE) {
            return this.scrollPosState.rowIndex;
        }
        int itemCount = this.materialScrollBar.recyclerView.getAdapter().getItemCount();
        int itemIndex = (int)((float)itemCount * this.materialScrollBar.currentScrollPercent);
        return itemIndex > 0 ? itemIndex - 1 : itemIndex;
    }

    private class ScrollPositionState {
        private int rowIndex;
        private int rowTopOffset;
        private int rowHeight;
        private int indicatorPosition;

        private ScrollPositionState() {
        }
    }
}

