/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import com.turingtechnologies.materialscrollbar.Utils;

@SuppressLint(value={"ViewConstructor"})
public class Handle
extends View {
    final int WIDTH = Utils.getDP(8, this);
    RectF handleArc;
    RectF handleHold;
    Paint p = new Paint();
    Integer mode;
    boolean expanded = false;
    Boolean rtl = false;

    public Handle(Context c, int m) {
        super(c);
        this.mode = m;
        this.p.setFlags(1);
    }

    void setRightToLeft(boolean rtl) {
        this.rtl = rtl;
    }

    public void setBackgroundColor(int color2) {
        this.p.setColor(color2);
    }

    public void collapseHandle() {
        this.expanded = true;
        this.invalidate();
    }

    protected void onAnimationEnd() {
        super.onAnimationEnd();
    }

    public void expandHandle() {
        this.expanded = false;
        this.invalidate();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mode == 0) {
            this.makeRect();
        } else {
            this.handleHold = this.rtl != false ? new RectF(new Rect(this.getLeft(), this.getTop(), this.getRight() - this.WIDTH / 2 - Utils.getDP(1, this), this.getBottom())) : new RectF(new Rect(this.getLeft() + this.WIDTH / 2 + Utils.getDP(1, this), this.getTop(), this.getRight(), this.getBottom()));
        }
    }

    private void makeRect() {
        if (this.rtl.booleanValue()) {
            this.handleArc = new RectF(new Rect(this.getRight() - this.WIDTH, this.getTop(), this.getRight(), this.getBottom()));
            this.handleHold = new RectF(new Rect(this.getLeft(), this.getTop(), this.getRight() - this.WIDTH / 2, this.getBottom()));
        } else {
            this.handleArc = new RectF(new Rect(this.getLeft(), this.getTop(), this.getLeft() + this.WIDTH, this.getBottom()));
            this.handleHold = new RectF(new Rect(this.getLeft() + this.WIDTH / 2, this.getTop(), this.getRight(), this.getBottom()));
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mode == 0 && !this.expanded) {
            canvas.drawRect(this.handleHold, this.p);
            canvas.drawArc(this.handleArc, this.rtl != false ? 270.0f : 90.0f, 180.0f, false, this.p);
        } else {
            canvas.drawRect(this.handleHold, this.p);
        }
    }
}

